/*
 * Decompiled with CFR 0.152.
 */
package com.levigo.util.messaging.dialog;

import com.levigo.util.messaging.Message;
import com.levigo.util.messaging.MessageEvent;
import com.levigo.util.messaging.MessageManager;
import com.levigo.util.messaging.dialog.DefaultTextResources;
import com.levigo.util.swing.IconManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.lang.reflect.Method;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;

public class DefaultMessageDialog
extends JDialog {
    public static boolean USE_UI_ICONS = true;
    private boolean detailsShown = false;
    private JScrollPane scrollPane;
    private boolean centerOnParent = false;
    private static final Icon WARN_SIGN = IconManager.getInstance(DefaultTextResources.class, "common-icons").getIcon("warnsign", 1);
    private MessageEvent event = null;
    private Action detailsExpander = new DetailsExpander();
    private JButton detailsButton = null;
    private WindowListener windowListener = null;
    private VetoableChangeListener installedVetoableChangeListener;
    private JTextField inputTextField = null;

    public DefaultMessageDialog(Frame owner, String title, MessageEvent e) {
        this(owner, title, e, false, false);
    }

    public DefaultMessageDialog(Frame owner, String title, MessageEvent e, boolean centerOnOwner) {
        this(owner, title, e, centerOnOwner, false);
    }

    public DefaultMessageDialog(Frame owner, String title, MessageEvent e, boolean centerOnOwner, boolean resizable) {
        super(owner, title, true);
        this.event = e;
        if (this.event != null) {
            this.centerOnParent = centerOnOwner;
            this.initGUI();
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    DefaultMessageDialog.this.event.getMessageResult().addResult("YES_NO_CANCEL_DECISION", "CANCEL_AFFIRMED");
                    DefaultMessageDialog.this.event.getMessageResult().addResult("BOOLEAN_DECISION", Boolean.FALSE);
                    DefaultMessageDialog.this.dispose();
                }
            });
        }
        if (owner != null) {
            this.windowListener = new WindowAdapter(){

                public void windowActivated(WindowEvent evt) {
                    if (DefaultMessageDialog.this.isModal()) {
                        DefaultMessageDialog.this.requestFocus();
                        DefaultMessageDialog.this.transferFocus();
                    }
                }
            };
            owner.addWindowListener(this.windowListener);
        }
        this.installFocusListener();
        this.pack();
        this.setResizable(resizable);
        this.locateDialog();
    }

    private void installKeyBoardActionsForButton(JButton aButton, boolean isOKButton, String inputMapKey, InputMap inputMap) {
        if (aButton != null) {
            int mnemonic = aButton.getMnemonic();
            if (mnemonic >= 65 && mnemonic <= 90) {
                mnemonic += 32;
            }
            if (mnemonic == 0) {
                if (isOKButton) {
                    if (aButton.getText().toLowerCase().startsWith("y")) {
                        mnemonic = 121;
                    } else if (aButton.getText().toLowerCase().startsWith("j")) {
                        mnemonic = 106;
                    } else if (aButton.getText().toLowerCase().startsWith("o")) {
                        mnemonic = 111;
                    }
                } else if (aButton.getText().toLowerCase().startsWith("c")) {
                    mnemonic = 99;
                } else if (aButton.getText().toLowerCase().startsWith("n")) {
                    mnemonic = 110;
                } else if (aButton.getText().toLowerCase().startsWith("a")) {
                    mnemonic = 97;
                }
            }
            if (mnemonic > 0) {
                aButton.setMnemonic(mnemonic);
                inputMap.put(KeyStroke.getKeyStroke((char)mnemonic), inputMapKey);
            }
        }
    }

    private void installKeyBoardActions(JButton okButton, JButton denyButton, JButton cancelButton, JButton aDetailsButton) {
        InputMap iMap = ((JComponent)this.getContentPane()).getInputMap(2);
        this.installKeyBoardActionsForButton(okButton, true, "YesAndClose", iMap);
        this.installKeyBoardActionsForButton(denyButton, false, "NoAndClose", iMap);
        this.installKeyBoardActionsForButton(cancelButton, false, "CancelAndClose", iMap);
        if (aDetailsButton != null) {
            aDetailsButton.setMnemonic(68);
            iMap.put(KeyStroke.getKeyStroke(68, 0), "Details");
        }
        iMap.put(KeyStroke.getKeyStroke(27, 0), "CancelAndClose");
        ActionMap aMap = ((JComponent)this.getContentPane()).getActionMap();
        aMap.put("YesAndClose", new FillResultAndDispose("YES_AFFIRMED"));
        aMap.put("NoAndClose", new FillResultAndDispose("NO_AFFIRMED"));
        aMap.put("CancelAndClose", new FillResultAndDispose("CANCEL_AFFIRMED"));
        aMap.put("Details", this.detailsExpander);
    }

    private String getMessageTitle() {
        Message message = this.event.getMessage();
        String completeTitleString = "";
        if (message.getTitleText() != null && !message.getTitleText().equals("")) {
            completeTitleString = completeTitleString + message.getTitleText() + "\n";
        }
        return completeTitleString;
    }

    private String getMessageBodyText() {
        Message message = this.event.getMessage();
        String completeMessageString = "";
        if (message.getBodyText() != null && !message.getBodyText().equals("")) {
            completeMessageString = completeMessageString + message.getBodyText() + "\n";
        }
        return completeMessageString;
    }

    private void initGUI() {
        if (this.event == null || this.event.getMessage() == null) {
            return;
        }
        this.getContentPane().setLayout(new BorderLayout());
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.add((Component)this.createMessageIconPane(), "West");
        topPanel.add((Component)this.createMessagePane(), "Center");
        this.getContentPane().add((Component)topPanel, "North");
    }

    private JButton createCancelButton() {
        String cancelButtonText;
        Message message = this.event.getMessage();
        JButton cancelButton = null;
        String string = cancelButtonText = message.getType() == "DISPLAY" || message.getType() == "CONFIRM" ? null : message.getControlLabels()[2];
        if (cancelButtonText != null) {
            cancelButton = new JButton(cancelButtonText);
            cancelButton.addActionListener(new FillResultAndDispose("CANCEL_AFFIRMED"));
            if (message.getControlMnemonics() != null && message.getControlMnemonics().length > 2) {
                cancelButton.setMnemonic(message.getControlMnemonics()[2] != null && message.getControlMnemonics()[2].length() > 0 ? message.getControlMnemonics()[2].charAt(0) : (char)'\u0000');
            }
        }
        return cancelButton;
    }

    private JButton createDenyButton() {
        String denyButtonText;
        Message message = this.event.getMessage();
        JButton denyButton = null;
        String string = denyButtonText = message.getType() == "DISPLAY" || message.getType() == "CONFIRM" ? null : message.getControlLabels()[1];
        if (denyButtonText != null) {
            denyButton = new JButton(denyButtonText);
            denyButton.addActionListener(new FillResultAndDispose("NO_AFFIRMED"));
            if (message.getControlMnemonics() != null && message.getControlMnemonics().length > 1) {
                denyButton.setMnemonic(message.getControlMnemonics()[1] != null && message.getControlMnemonics()[1].length() > 0 ? message.getControlMnemonics()[1].charAt(0) : (char)'\u0000');
            }
        }
        return denyButton;
    }

    private JButton createOKButton() {
        Message message = this.event.getMessage();
        JButton okButton = new JButton(message.getControlLabels()[0]);
        this.getRootPane().setDefaultButton(okButton);
        okButton.addActionListener(new FillResultAndDispose("YES_AFFIRMED"));
        if (message.getControlMnemonics() != null && message.getControlMnemonics().length > 0) {
            okButton.setMnemonic(message.getControlMnemonics()[0] != null && message.getControlMnemonics()[0].length() > 0 ? message.getControlMnemonics()[0].charAt(0) : (char)'\u0000');
        }
        return okButton;
    }

    private JCheckBox createSuppressingCheckbox() {
        JCheckBox checkBox = null;
        if (this.event.getMessage().isSuppressable()) {
            checkBox = new JCheckBox(DefaultTextResources.getString("message.dontshowagain"));
            checkBox.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        MessageManager.suppressMessage(DefaultMessageDialog.this.event.getMessage().getIdentifier());
                    } else if (e.getStateChange() == 2) {
                        MessageManager.unsuppressMessage(DefaultMessageDialog.this.event.getMessage().getIdentifier());
                    }
                }
            });
            LookAndFeel.installColorsAndFont(checkBox, "Label.background", "Label.foreground", "TextField.font");
        }
        return checkBox;
    }

    private JButton createDetailsButton() {
        Message message = this.event.getMessage();
        if (!(message.getDetailsText() == null || message.getDetailsText().trim().equals("") || message.getDetailsText().trim().equals("\n") || message.getDetailsText().trim().equals("null"))) {
            this.detailsButton = new JButton(">> " + DefaultTextResources.getString("message.details"));
            this.detailsButton.addActionListener(this.detailsExpander);
        }
        return this.detailsButton;
    }

    private JPanel createMessagePane() {
        JPanel rightSide = new JPanel();
        rightSide.setLayout(new BoxLayout(rightSide, 1));
        rightSide.setBorder(BorderFactory.createEmptyBorder(20, 0, 0, 10));
        JTextArea titleTxt = this.createMessageTextArea(this.getMessageTitle());
        titleTxt.setFont(new FontUIResource("sansserif", 1, 12));
        rightSide.add(titleTxt);
        JTextArea messageTxt = this.createMessageTextArea(this.getMessageBodyText());
        if (messageTxt.getLineCount() > 8) {
            messageTxt.setRows(7);
            rightSide.add(new JScrollPane(messageTxt));
        } else {
            rightSide.add(messageTxt);
        }
        if (this.event.getMessage().getType().equals("INPUT")) {
            this.inputTextField = new JTextField(DefaultTextResources.getString("message.input.initialText"));
            this.inputTextField.select(0, this.inputTextField.getText().length());
            rightSide.add(this.inputTextField);
            rightSide.add(Box.createVerticalStrut(20));
        }
        if (this.event.getMessage().getType().equals("HIDDEN_INPUT")) {
            this.inputTextField = new JPasswordField("");
            this.inputTextField.select(0, this.inputTextField.getText().length());
            rightSide.add(this.inputTextField);
            rightSide.add(Box.createVerticalStrut(20));
        }
        rightSide.add(this.createButtonPane());
        return rightSide;
    }

    private JPanel createMessageIconPane() {
        JPanel leftSide = new JPanel();
        leftSide.setLayout(new BoxLayout(leftSide, 1));
        leftSide.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        leftSide.add(Box.createVerticalGlue());
        Icon icon = WARN_SIGN;
        if (USE_UI_ICONS) {
            icon = this.event.getMessage().getType().equals("DISPLAY") || this.event.getMessage().getType().equals("NOTICE") ? (this.event.getMessage().getSeverity().equals("WARNING") ? UIManager.getIcon("OptionPane.warningIcon") : (this.event.getMessage().getSeverity().equals("ERROR") ? UIManager.getIcon("OptionPane.errorIcon") : UIManager.getIcon("OptionPane.informationIcon"))) : UIManager.getIcon("OptionPane.questionIcon");
        }
        leftSide.add(new JLabel(icon));
        leftSide.add(new JLabel(""));
        leftSide.add(Box.createVerticalGlue());
        return leftSide;
    }

    private JPanel createButtonPane() {
        JButton cancelButton;
        JPanel buttonPane = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets.right = 10;
        c.insets.left = 10;
        c.insets.bottom = 5;
        c.insets.top = 5;
        c.anchor = 17;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.ipady = 0;
        c.ipadx = 0;
        c.fill = 1;
        JButton okButton = this.createOKButton();
        buttonPane.add((Component)okButton, c);
        JButton denyButton = this.createDenyButton();
        if (denyButton != null) {
            buttonPane.add((Component)denyButton, c);
        }
        if ((cancelButton = this.createCancelButton()) != null) {
            buttonPane.add((Component)cancelButton, c);
        }
        this.detailsButton = this.createDetailsButton();
        if (null != this.detailsButton) {
            buttonPane.add((Component)this.detailsButton, c);
        }
        c.gridy = 1;
        c.gridwidth = 3;
        JCheckBox checkBox = this.createSuppressingCheckbox();
        if (null != checkBox) {
            buttonPane.add((Component)checkBox, c);
        }
        this.installKeyBoardActions(okButton, denyButton, cancelButton, this.detailsButton);
        return buttonPane;
    }

    private JTextArea createMessageTextArea(String initialText) {
        JTextArea textArea = new JTextArea(){

            public boolean isFocusTraversable() {
                return false;
            }
        };
        LookAndFeel.installColorsAndFont(textArea, "Label.background", "Label.foreground", "TextField.font");
        LookAndFeel.installBorder(textArea, "Label.border");
        textArea.setRequestFocusEnabled(false);
        textArea.setEditable(false);
        textArea.setHighlighter(null);
        textArea.setMargin(new Insets(0, 0, 0, 0));
        textArea.setText(initialText);
        textArea.setCaretPosition(0);
        return textArea;
    }

    private void locateDialog() {
        if (this.centerOnParent) {
            int x = 0;
            int y = 0;
            Container parent = this.getParent();
            x = parent.getWidth() >= this.getWidth() ? parent.getX() + (parent.getWidth() - this.getWidth()) / 2 : parent.getX() + 20;
            y = parent.getHeight() >= this.getHeight() ? parent.getY() + (parent.getHeight() - this.getHeight()) / 2 : parent.getY() + 20;
            Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
            if (x + this.getWidth() > screen.width) {
                x = screen.width - this.getWidth();
            }
            if (y + this.getHeight() > screen.height) {
                y = screen.height - this.getHeight();
            }
            this.setLocation(x, y);
        } else {
            Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
            this.setLocation((screen.width - this.getSize().width) / 2, (screen.height - this.getSize().height) / 2);
        }
    }

    private void showDetails() {
        JTextArea detailsTxtArea = new JTextArea(this.event.getMessage().getDetailsText());
        detailsTxtArea.setEditable(false);
        detailsTxtArea.setBackground(SystemColor.menu);
        this.scrollPane = new JScrollPane(detailsTxtArea);
        this.scrollPane.setPreferredSize(new Dimension(300, 150));
        this.getContentPane().add((Component)this.scrollPane, "Center");
        this.pack();
        this.detailsShown = true;
        this.invalidate();
        this.repaint();
    }

    private void removeDetails() {
        this.getContentPane().remove(this.scrollPane);
        this.pack();
        this.detailsShown = false;
    }

    public void dispose() {
        super.dispose();
        if (this.getOwner() != null) {
            this.getOwner().removeWindowListener(this.windowListener);
        }
        if (this.installedVetoableChangeListener != null) {
            try {
                Class<?> kfmClass = Class.forName("java.awt.KeyboardFocusManager");
                Method getCurrentKeyboardFocusManager = kfmClass.getDeclaredMethod("getCurrentKeyboardFocusManager", null);
                Object currentKeyboardFocusManager = getCurrentKeyboardFocusManager.invoke(kfmClass, (Object[])null);
                Class[] vetoClassArray = new Class[]{VetoableChangeListener.class};
                Method removeVetoableChangeListener = currentKeyboardFocusManager.getClass().getMethod("removeVetoableChangeListener", vetoClassArray);
                removeVetoableChangeListener.invoke(currentKeyboardFocusManager, this.installedVetoableChangeListener);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void installFocusListener() {
        boolean available = false;
        try {
            available = Integer.parseInt(System.getProperty("java.version").substring(2, 3)) > 4;
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (available) {
            try {
                Class<?> kfmClass = Class.forName("java.awt.KeyboardFocusManager");
                Method getCurrentKeyboardFocusManager = kfmClass.getDeclaredMethod("getCurrentKeyboardFocusManager", null);
                Object currentKeyboardFocusManager = getCurrentKeyboardFocusManager.invoke(kfmClass, (Object[])null);
                Class[] vetoClassArray = new Class[]{VetoableChangeListener.class};
                Method addVetoableChangeListener = currentKeyboardFocusManager.getClass().getMethod("addVetoableChangeListener", vetoClassArray);
                this.installedVetoableChangeListener = new VetoableChangeListener(){

                    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
                        if ("activeWindow".equals(evt.getPropertyName()) && DefaultMessageDialog.this.isVisible() && !(evt.getOldValue() instanceof DefaultMessageDialog) && !(evt.getNewValue() instanceof DefaultMessageDialog)) {
                            DefaultMessageDialog.this.toFront();
                        }
                    }
                };
                addVetoableChangeListener.invoke(currentKeyboardFocusManager, this.installedVetoableChangeListener);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    private class DetailsExpander
    extends AbstractAction {
        private DetailsExpander() {
        }

        public void actionPerformed(ActionEvent e) {
            if (!DefaultMessageDialog.this.detailsShown) {
                DefaultMessageDialog.this.showDetails();
                DefaultMessageDialog.this.detailsButton.setText("<< Details");
            } else {
                DefaultMessageDialog.this.removeDetails();
                DefaultMessageDialog.this.detailsButton.setText(">> Details");
            }
        }
    }

    private class FillResultAndDispose
    extends AbstractAction {
        private String result = "YES_AFFIRMED";

        public FillResultAndDispose(String messageAffirmed) {
            this.result = messageAffirmed;
        }

        public void actionPerformed(ActionEvent e) {
            if (DefaultMessageDialog.this.event != null) {
                DefaultMessageDialog.this.event.getMessageResult().addResult("YES_NO_CANCEL_DECISION", this.result);
                if ((DefaultMessageDialog.this.event.getMessage().getType().equals("INPUT") || DefaultMessageDialog.this.event.getMessage().getType().equals("HIDDEN_INPUT")) && DefaultMessageDialog.this.inputTextField != null) {
                    String inputText;
                    if (DefaultMessageDialog.this.inputTextField instanceof JPasswordField) {
                        char[] password = ((JPasswordField)DefaultMessageDialog.this.inputTextField).getPassword();
                        inputText = new String(password);
                    } else {
                        inputText = DefaultMessageDialog.this.inputTextField.getText();
                    }
                    DefaultMessageDialog.this.event.getMessageResult().addResult("STANDARD_INPUT_STRING", inputText);
                }
                if ("YES_AFFIRMED".equals(this.result)) {
                    DefaultMessageDialog.this.event.getMessageResult().addResult("BOOLEAN_DECISION", Boolean.TRUE);
                } else if ("NO_AFFIRMED".equals(this.result) || "CANCEL_AFFIRMED".equals(this.result)) {
                    DefaultMessageDialog.this.event.getMessageResult().addResult("BOOLEAN_DECISION", Boolean.FALSE);
                }
            }
            DefaultMessageDialog.this.dispose();
        }
    }
}

