/*
 * Decompiled with CFR 0.152.
 */
package com.levigo.util.messaging.printstreams;

import com.levigo.util.messaging.Message;
import com.levigo.util.messaging.MessageEvent;
import com.levigo.util.messaging.MessageListener;
import java.io.PrintStream;

public class MessagePrintStream
implements MessageListener {
    private PrintStream aStream = null;

    MessagePrintStream(PrintStream validStream) {
        this.setPrintStream(validStream);
    }

    public void displayMessage(MessageEvent e) {
        Message messageToDisplay = e.getMessage();
        if (messageToDisplay == null || this.getPrintStream() == null) {
            return;
        }
        this.getPrintStream().println("Title: " + messageToDisplay.getTitleText());
        this.getPrintStream().println("Body: " + messageToDisplay.getBodyText());
        this.getPrintStream().println("Details: " + messageToDisplay.getDetailsText());
        this.getPrintStream().println("Source: " + e.getSource().toString());
        this.getPrintStream().println();
    }

    public PrintStream getPrintStream() {
        return this.aStream;
    }

    public void setPrintStream(PrintStream aStream) {
        this.aStream = aStream;
    }

    protected void finalize() throws Throwable {
        if (this.getPrintStream() != null) {
            this.setPrintStream(null);
        }
        super.finalize();
    }
}

