/*
 * Decompiled with CFR 0.152.
 */
package com.levigo.util.progress;

import com.levigo.util.progress.ProgressEvent;
import com.levigo.util.progress.ProgressManager;
import com.levigo.util.progress.ProgressSource;
import java.text.NumberFormat;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JProgressBar;
import org.apache.log4j.Logger;

public class Progress {
    private Logger logger = Logger.getLogger((Class)Progress.class);
    private boolean isCancelled = false;
    private int minimum = 0;
    private int maximum = 0;
    private int current = 0;
    private String note = null;
    private boolean determinate = false;
    private JProgressBar progressBar = null;
    private BoundedRangeModel rangeModel = null;
    private ProgressSource source;
    private String status = "";

    public Progress() {
    }

    public Progress(int min, int max, int current, String note, boolean determinate, ProgressSource source) {
        this.note = note;
        this.determinate = determinate;
        this.source = source;
        this.checkMinToSet(min);
        this.checkMaxToSet(max);
        this.checkCurrentToSet(current);
        this.maximum = max;
        this.minimum = min;
        this.current = current;
    }

    public void setMinimum(int min) {
        this.checkMinToSet(min);
        this.minimum = min;
        if (null != this.rangeModel) {
            this.rangeModel.setMinimum(this.minimum);
        }
    }

    protected void checkMinToSet(int min) throws IllegalArgumentException {
        if (min > this.maximum) {
            throw new IllegalArgumentException("min value > max value.");
        }
    }

    public void setMaximum(int max) {
        this.checkMaxToSet(max);
        this.maximum = max;
        this.logger.debug((Object)("setMaximum() = " + max));
        if (null != this.rangeModel) {
            this.rangeModel.setMaximum(this.maximum);
        }
    }

    protected void checkMaxToSet(int max) throws IllegalArgumentException {
        if (max < this.minimum) {
            throw new IllegalArgumentException("max value < min value.");
        }
    }

    public int getMinimum() {
        return this.minimum;
    }

    public int getMaximum() {
        this.logger.debug((Object)("getMaximum() = " + this.maximum));
        return this.maximum;
    }

    public int getValue() {
        return this.current;
    }

    public void setValue(int current) {
        this.logger.debug((Object)("setValue() = " + current));
        this.checkCurrentToSet(current);
        this.current = current;
        if (null != this.rangeModel) {
            this.rangeModel.setValue(current);
        }
        NumberFormat percentFormatter = NumberFormat.getPercentInstance();
        String percentOut = percentFormatter.format(this.getPercentComplete());
        this.logger.debug((Object)("percentOut: " + percentOut));
        if (null != this.progressBar) {
            this.progressBar.setString(percentOut);
        }
        if (current < this.maximum) {
            ProgressManager.getInstance().fireProgressEvent(new ProgressEvent(this.source, "progressChanged", "inProgress"));
        }
    }

    public void setStatus(String status) {
        if (this.status == status) {
            return;
        }
        ProgressManager.getInstance().fireProgressEvent(new ProgressEvent(this.source, "statusChanged", status));
    }

    protected void checkCurrentToSet(int current) throws IllegalArgumentException {
        if (this.determinate && (current < this.minimum || current > this.maximum + 1)) {
            throw new IllegalArgumentException("current[" + current + "] < min value[" + this.minimum + "] or current[" + current + "] > max value[" + this.maximum + "].");
        }
    }

    public float getPercentComplete() {
        float diff = this.maximum - this.minimum;
        float done = this.current - this.minimum;
        if (diff <= 0.0f) {
            return -1.0f;
        }
        float result = done / diff;
        this.logger.debug((Object)("getPercentComplete(): " + result));
        return result;
    }

    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
        ProgressManager.getInstance().fireProgressEvent(new ProgressEvent(this.source, "progressChanged", "inProgress"));
    }

    public void setDeterminate(boolean determinate) {
        this.determinate = determinate;
    }

    public boolean isDeterminate() {
        return this.determinate;
    }

    public JProgressBar getProgressBar() {
        if (null == this.progressBar) {
            this.progressBar = new JProgressBar(this.getModel());
            this.progressBar.setStringPainted(true);
            this.progressBar.setString("0%");
        }
        return this.progressBar;
    }

    public BoundedRangeModel getModel() {
        if (null == this.rangeModel) {
            this.rangeModel = new DefaultBoundedRangeModel(this.current, 0, this.minimum, this.maximum);
        }
        return this.rangeModel;
    }

    public void setModel(BoundedRangeModel model) {
        BoundedRangeModel oldModel = this.rangeModel;
        this.rangeModel = new DefaultBoundedRangeModel();
        try {
            if (this.determinate) {
                this.setMaximum(model.getMaximum());
                this.setMinimum(model.getMinimum());
            }
            this.setValue(model.getValue());
        }
        catch (IllegalArgumentException x) {
            this.rangeModel = oldModel;
        }
        if (null != this.progressBar) {
            this.progressBar.setModel(this.rangeModel);
        }
    }

    public void setProgressBar(JProgressBar progressBar) {
        this.progressBar = progressBar;
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    public void setCancelled(boolean cancelled) {
        this.isCancelled = cancelled;
    }
}

