/*
 * Decompiled with CFR 0.152.
 */
package com.levigo.util.swing;

import com.levigo.util.log.Log;
import com.levigo.util.swing.AbstractGeometryFrame;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.lang.reflect.Method;
import javax.swing.JFrame;

public abstract class AbstractPropertyGeometryFrame
extends AbstractGeometryFrame {
    private static Insets frameInsets = null;
    private static boolean restoreGeometry = true;
    private static boolean adjustGeometry = false;
    private static boolean isExtendedStateAvailable = false;
    private static WindowComponentObserver windowComponentObserver = null;
    private boolean deferredExtendedStateRestore;
    private boolean geometryRestored;

    public AbstractPropertyGeometryFrame(String title) {
        super(title);
    }

    public AbstractPropertyGeometryFrame() {
        this("");
    }

    public void saveGeometry() {
        if (AbstractPropertyGeometryFrame.isRestoreGeometryEnabled() && null != AbstractPropertyGeometryFrame.getPreferenceStore()) {
            int extendedState = 0;
            if (isExtendedStateAvailable) {
                try {
                    Method getExtendedStateMethod = this.getClass().getMethod("getExtendedState", new Class[0]);
                    extendedState = (Integer)getExtendedStateMethod.invoke((Object)this, new Object[0]);
                    AbstractPropertyGeometryFrame.getPreferenceStore().putPreference("window." + this.getFrameType() + ".extendedState", extendedState);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (this.isShowing() && (isExtendedStateAvailable && extendedState == 0 || !isExtendedStateAvailable)) {
                AbstractPropertyGeometryFrame.getPreferenceStore().putPreference("window." + this.getFrameType() + ".position.x", (Object)("" + this.getLocation().x));
                AbstractPropertyGeometryFrame.getPreferenceStore().putPreference("window." + this.getFrameType() + ".position.y", (Object)("" + this.getLocation().y));
                AbstractPropertyGeometryFrame.getPreferenceStore().putPreference("window." + this.getFrameType() + ".size.w", (Object)("" + this.getSize().width));
                AbstractPropertyGeometryFrame.getPreferenceStore().putPreference("window." + this.getFrameType() + ".size.h", (Object)("" + this.getSize().height));
            }
        }
    }

    public void restoreGeometry() {
        this.geometryRestored = false;
        boolean applyDefaults = true;
        if (null != AbstractPropertyGeometryFrame.getPreferenceStore()) {
            if (AbstractPropertyGeometryFrame.isRestoreGeometryEnabled()) {
                try {
                    this.setLocation(this.getStoredLocation());
                    this.setSize(this.getStoredSize());
                    this.restoreExtendedState();
                    applyDefaults = false;
                }
                catch (Throwable t) {
                    Log.error((String)this.getClass().getName(), (String)"Geometry restoring was not sucessfull. Frame is positioned and sized with default values.");
                }
            }
            if (AbstractPropertyGeometryFrame.isAdjustGeometryEnabled()) {
                try {
                    this.setBounds(this.getAdjustedBounds(this.getBounds()));
                    this.restoreExtendedState();
                    applyDefaults = false;
                }
                catch (Throwable t) {
                    Log.error((String)this.getClass().getName(), (String)"Adapting frames geometry to screen was not sucessfull. Frame is positioned and sized with default values.");
                }
            }
        }
        if (applyDefaults) {
            this.setBounds(this.getAdjustedBounds(new Rectangle(this.getDefaultLocation(), this.getDefaultSize())));
        }
    }

    private Rectangle getAdjustedBounds(Rectangle bounds) {
        if (bounds.width <= 0) {
            bounds.setSize(this.getDefaultSize().width, this.getSize().height);
        }
        if (bounds.height <= 0) {
            bounds.setSize(this.getSize().width, this.getDefaultSize().height);
        }
        Rectangle checkBounds = (Rectangle)bounds.clone();
        if (frameInsets == null) {
            JFrame f = new JFrame();
            f.pack();
            frameInsets = f.getInsets();
        }
        checkBounds.translate(AbstractPropertyGeometryFrame.frameInsets.left, AbstractPropertyGeometryFrame.frameInsets.top);
        boolean locationIsValid = false;
        GraphicsDevice[] graphicsDevices = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
        Rectangle targetDeviceBounds = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getBounds();
        for (int j = 0; j < graphicsDevices.length; ++j) {
            GraphicsConfiguration gc = graphicsDevices[j].getDefaultConfiguration();
            Rectangle deviceBounds = new Rectangle(gc.getBounds());
            Insets screenInsets = this.getToolkit().getScreenInsets(gc);
            deviceBounds.setBounds(deviceBounds.x + screenInsets.left, deviceBounds.y + screenInsets.top, deviceBounds.width - screenInsets.left - screenInsets.right, deviceBounds.height - screenInsets.top - screenInsets.bottom);
            if (!deviceBounds.contains(checkBounds.getLocation())) continue;
            locationIsValid = true;
            targetDeviceBounds = deviceBounds;
            break;
        }
        if (!locationIsValid) {
            bounds.setLocation(this.getDefaultLocation());
        }
        while (this.isExistingFrameAt(bounds.getLocation())) {
            bounds.translate(20, 20);
            int maxX = targetDeviceBounds.x + targetDeviceBounds.width;
            int maxY = targetDeviceBounds.y + targetDeviceBounds.height;
            if (bounds.getX() > (double)(maxX * 2 / 3)) {
                bounds.setLocation(40, (int)bounds.getY());
            }
            if (!(bounds.getY() > (double)(maxY * 2 / 3))) continue;
            bounds.setLocation((int)bounds.getX(), 20);
        }
        return bounds;
    }

    public void addNotify() {
        super.addNotify();
        if (this.deferredExtendedStateRestore) {
            this.doRestoreExtendedState();
        }
        this.addComponentListener(windowComponentObserver);
    }

    public void removeNotify() {
        super.removeNotify();
        this.removeComponentListener(windowComponentObserver);
    }

    public void show() {
        super.show();
        if (this.deferredExtendedStateRestore) {
            this.deferredExtendedStateRestore = false;
        }
    }

    private Point getStoredLocation() {
        Point defaultLocation = this.getDefaultLocation();
        Point storedLocation = new Point(defaultLocation);
        if (null != AbstractPropertyGeometryFrame.getPreferenceStore()) {
            storedLocation.x = AbstractPropertyGeometryFrame.getPreferenceStore().getPreferenceAsInt("window." + this.getFrameType() + ".position.x", storedLocation.x);
            storedLocation.y = AbstractPropertyGeometryFrame.getPreferenceStore().getPreferenceAsInt("window." + this.getFrameType() + ".position.y", storedLocation.y);
            this.geometryRestored = !storedLocation.equals(defaultLocation);
        }
        return storedLocation;
    }

    private Dimension getStoredSize() {
        Dimension defaultSize = this.getDefaultSize();
        Dimension storedSize = new Dimension(defaultSize);
        if (null != AbstractPropertyGeometryFrame.getPreferenceStore()) {
            storedSize.width = AbstractPropertyGeometryFrame.getPreferenceStore().getPreferenceAsInt("window." + this.getFrameType() + ".size.w", storedSize.width);
            storedSize.height = AbstractPropertyGeometryFrame.getPreferenceStore().getPreferenceAsInt("window." + this.getFrameType() + ".size.h", storedSize.height);
            this.geometryRestored = !storedSize.equals(defaultSize);
        }
        return storedSize;
    }

    private void restoreExtendedState() {
        if (!this.isVisible()) {
            this.deferredExtendedStateRestore = true;
        } else {
            this.doRestoreExtendedState();
        }
    }

    private void doRestoreExtendedState() {
        this.deferredExtendedStateRestore = false;
        if (isExtendedStateAvailable) {
            try {
                Method setExtendedStateMethod = this.getClass().getMethod("setExtendedState", Integer.TYPE);
                int extendedState = AbstractPropertyGeometryFrame.getPreferenceStore().getPreferenceAsInt("window." + this.getFrameType() + ".extendedState", 0);
                Object[] paramArray = new Object[]{new Integer(extendedState &= 0xFFFFFFFE)};
                setExtendedStateMethod.invoke((Object)this, paramArray);
            }
            catch (Throwable t) {
                Log.error((String)this.getClass().getName(), (String)"Could not restore extended state, perhaps extended state value is invalid.");
            }
        }
    }

    public boolean isGeometryRestored() {
        return this.geometryRestored;
    }

    public static boolean isRestoreGeometryEnabled() {
        return restoreGeometry;
    }

    public static void setRestoreGeometryEnabled(boolean doRestoreGeometry) {
        restoreGeometry = doRestoreGeometry;
    }

    public static boolean isAdjustGeometryEnabled() {
        return adjustGeometry;
    }

    public static void setAdjustGeometryEnabled(boolean doAdjustGeometry) {
        adjustGeometry = doAdjustGeometry;
    }

    static {
        windowComponentObserver = new WindowComponentObserver();
        try {
            isExtendedStateAvailable = Integer.parseInt(System.getProperty("java.version").substring(2, 3)) > 4;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static class WindowComponentObserver
    extends ComponentAdapter {
        private WindowComponentObserver() {
        }

        public void componentMoved(ComponentEvent e) {
            AbstractPropertyGeometryFrame source;
            if (e.getSource() instanceof AbstractPropertyGeometryFrame && this.doSaveGeometry(source = (AbstractPropertyGeometryFrame)e.getSource())) {
                source.saveGeometry();
            }
        }

        private boolean doSaveGeometry(AbstractPropertyGeometryFrame source) {
            boolean doSave = false;
            GraphicsDevice[] graphicsDevices = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
            for (int j = 0; !doSave && j < graphicsDevices.length; ++j) {
                doSave = graphicsDevices[j].getDefaultConfiguration().getBounds().contains(source.getLocation());
            }
            return doSave;
        }

        public void componentResized(ComponentEvent e) {
            if (e.getSource() instanceof AbstractPropertyGeometryFrame) {
                ((AbstractPropertyGeometryFrame)e.getSource()).saveGeometry();
            }
        }
    }
}

