/*
 * Decompiled with CFR 0.152.
 */
package com.levigo.util.swing;

import com.levigo.util.swing.SelectableNode;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class CheckBoxTree
extends JTree {
    public CheckBoxTree(DefaultTreeModel model) {
        super(model);
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                TreePath p = CheckBoxTree.this.getPathForLocation(e.getX(), e.getY());
                if (p.getLastPathComponent() != null) {
                    SelectableNode tnw;
                    tnw.setSelected(!(tnw = (SelectableNode)p.getLastPathComponent()).isSelected());
                    ((DefaultTreeModel)CheckBoxTree.this.getModel()).nodeChanged((TreeNode)p.getLastPathComponent());
                }
            }
        });
    }

    public void setCellRenderer(TreeCellRenderer renderer) {
        super.setCellRenderer(new CheckBoxRenderDecorator(renderer));
    }

    private static class CheckBoxRenderDecorator
    implements TreeCellRenderer {
        private final TreeCellRenderer renderer;
        private JCheckBox box = new JCheckBox();
        private JPanel panel = new JPanel();

        public CheckBoxRenderDecorator(TreeCellRenderer parentRenderer) {
            this.renderer = parentRenderer;
            this.box.setText("");
            this.box.setOpaque(false);
            this.panel.setLayout(new BorderLayout());
            this.panel.setOpaque(false);
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Component c = this.renderer.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            if (value instanceof SelectableNode && ((SelectableNode)value).isSelectable()) {
                this.box.setSelected(((SelectableNode)value).isSelected());
                this.panel.removeAll();
                this.panel.add((Component)this.box, "West");
                this.panel.add(c, "East");
                c = this.panel;
            }
            return c;
        }
    }
}

