/*
 * Decompiled with CFR 0.152.
 */
package com.levigo.util.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.SystemColor;
import javax.swing.JMenuBar;

public class ImageMenuBar
extends JMenuBar {
    private Image mBarImage = null;
    private int imgHeight = -1;
    private int imgWidth = -1;
    private boolean drawBottomLine = false;

    public ImageMenuBar() {
    }

    public ImageMenuBar(boolean bottomLinedMenuBar) {
        this();
        this.drawBottomLine = bottomLinedMenuBar;
    }

    public ImageMenuBar(Image menuBarImage) {
        this();
        this.setImage(menuBarImage);
    }

    public ImageMenuBar(Image menuBarImage, boolean bottomLinedMenuBar) {
        this(menuBarImage);
        this.drawBottomLine = bottomLinedMenuBar;
    }

    public Dimension getMinimumSize() {
        Dimension d = super.getMinimumSize();
        if (this.mBarImage != null) {
            d.width = Math.max(d.width, this.imgWidth);
            d.height = Math.max(d.height, this.imgHeight);
        }
        return d;
    }

    public Dimension getPreferredSize() {
        Dimension d = super.getPreferredSize();
        d.height = Math.max(d.height, this.imgHeight);
        return d;
    }

    public void paint(Graphics g) {
        super.paint(g);
        Dimension mySize = this.getSize();
        if (this.mBarImage != null) {
            g.drawImage(this.mBarImage, mySize.width - this.imgWidth - 2, Math.max(2, (mySize.height - this.imgHeight) / 2), this);
        }
        if (this.drawBottomLine) {
            g.setColor(Color.black);
            g.drawLine(0, mySize.height - 2, mySize.width - 1, mySize.height - 2);
            g.setColor(SystemColor.controlShadow);
            g.drawLine(0, mySize.height - 1, mySize.width - 1, mySize.height - 1);
        }
    }

    public void setImage(Image image) {
        if (this.mBarImage != null) {
            this.mBarImage.flush();
        }
        this.mBarImage = image;
        this.imgHeight = -1;
        this.imgWidth = -1;
        if (this.mBarImage != null) {
            MediaTracker mt = new MediaTracker(this);
            mt.addImage(this.mBarImage, 0);
            try {
                mt.waitForAll();
            }
            catch (Exception exception) {
                // empty catch block
            }
            mt.removeImage(this.mBarImage);
            mt = null;
            this.imgHeight = this.mBarImage.getHeight(this) + 2;
            this.imgWidth = this.mBarImage.getWidth(this) + 2;
            this.invalidate();
            this.validate();
            this.repaint();
        }
    }
}

