/*
 * Decompiled with CFR 0.152.
 */
package com.levigo.util.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MediaTracker;
import java.awt.SystemColor;
import javax.swing.border.AbstractBorder;

public class ImageTitledBorder
extends AbstractBorder {
    private String title;
    private Image myImage;
    private int imgWidth = -1;
    private int imgHeight = -1;

    public ImageTitledBorder(String title, Image titleImage) {
        this.setTitle(title);
        this.setImage(titleImage);
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        if (this.imgWidth < 0 || this.imgHeight < 0) {
            this.calculateImageSize(c);
        }
        g.setFont(c.getFont());
        FontMetrics aFMetrics = g.getFontMetrics();
        int myHeight = aFMetrics.getHeight();
        Color origColor = g.getColor();
        g.setColor(SystemColor.controlLtHighlight);
        g.drawRect(x + 1, myHeight / 2 + 1, width - 2, height - 2 - myHeight / 2);
        g.setColor(SystemColor.controlShadow);
        g.drawRect(x, myHeight / 2, width - 2, height - 2 - myHeight / 2);
        g.setColor(c.getBackground());
        g.clearRect(x + 10, y, aFMetrics.stringWidth(this.title) + x + 10 + this.imgWidth, Math.max(aFMetrics.getHeight(), this.imgHeight));
        g.setColor(c.getForeground());
        g.drawImage(this.myImage, x + 12, y, c);
        g.drawString(this.title, x + 16 + this.imgWidth, y + aFMetrics.getAscent());
        g.setColor(origColor);
    }

    public Insets getBorderInsets(Component c) {
        Insets inset = new Insets(0, 0, 0, 0);
        return this.getBorderInsets(c, inset);
    }

    public Insets getBorderInsets(Component c, Insets insets) {
        Graphics g = c.getGraphics();
        FontMetrics aFMetrics = g.getFontMetrics();
        g.dispose();
        insets.bottom = 2;
        insets.right = 2;
        insets.left = 2;
        this.calculateImageSize(c);
        insets.top = Math.max(aFMetrics.getHeight(), this.imgHeight);
        return insets;
    }

    public boolean isBorderOpaque() {
        return false;
    }

    private void calculateImageSize(Component c) {
        if ((this.imgWidth < 0 || this.imgHeight < 0) && this.myImage != null) {
            MediaTracker mt = new MediaTracker(c);
            mt.addImage(this.myImage, 0);
            try {
                mt.waitForAll();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.imgWidth = this.myImage.getWidth(c);
            this.imgHeight = this.myImage.getHeight(c);
        }
    }

    private void setImage(Image image) {
        if (this.myImage != null) {
            this.myImage.flush();
        }
        this.imgWidth = -1;
        this.imgHeight = -1;
        this.myImage = image;
    }

    private void setTitle(String title) {
        this.title = title;
    }
}

