/*
 * Decompiled with CFR 0.152.
 */
package com.levigo.util.swing;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

public class JButtonGroup
extends ButtonGroup {
    private static final AbstractButton dummyButton = new JButton();
    private AbstractButton selectedButton;
    private EventListenerList listenerList = null;

    public JButtonGroup() {
        this.add(dummyButton);
    }

    public JButtonGroup(AbstractButton[] buttons) {
        this();
        this.add(buttons);
    }

    public void addChangeListener(ChangeListener l) {
        if (l == null) {
            return;
        }
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(ChangeListener.class, l);
    }

    public void removeChangeListener(ChangeListener l) {
        if (this.listenerList == null || l == null) {
            return;
        }
        this.listenerList.remove(ChangeListener.class, l);
    }

    protected void fireStateChanged() {
        if (this.listenerList == null || this.listenerList.getListenerCount() == 0) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$javax$swing$event$ChangeListener == null ? JButtonGroup.class$("javax.swing.event.ChangeListener") : class$javax$swing$event$ChangeListener)) continue;
            ChangeEvent changeEvent = new ChangeEvent(this);
            ((ChangeListener)listeners[i + 1]).stateChanged(changeEvent);
        }
    }

    public void add(AbstractButton button) {
        if (button == null || this.buttons.contains(button)) {
            return;
        }
        super.add(button);
        if (this.getSelection() == button.getModel()) {
            this.selectedButton = button;
        }
    }

    public void add(AbstractButton[] buttons) {
        if (buttons == null || buttons.length == 0) {
            return;
        }
        for (int i = 0; i < buttons.length; ++i) {
            this.add(buttons[i]);
        }
    }

    public void remove(AbstractButton button) {
        if (button != null) {
            if (this.selectedButton == button) {
                this.selectedButton = null;
            }
            super.remove(button);
        }
    }

    public void remove(AbstractButton[] buttons) {
        if (buttons == null || buttons.length == 0) {
            return;
        }
        for (int i = 0; i < buttons.length; ++i) {
            this.remove(buttons[i]);
        }
    }

    public void setSelected(AbstractButton button, boolean selected) {
        if (button != null && this.buttons.contains(button)) {
            this.setSelected(button.getModel(), selected);
        }
    }

    public void setSelected(ButtonModel model, boolean selected) {
        if (model == null) {
            return;
        }
        AbstractButton button = this.getButton(model);
        if (button != null && this.buttons.contains(button)) {
            if (selected && this.selectedButton == button) {
                return;
            }
            super.setSelected(model, selected);
            if (model == this.getSelection() && model != dummyButton.getModel()) {
                this.selectedButton = button;
            }
            this.fireStateChanged();
        }
    }

    public AbstractButton getButton(ButtonModel model) {
        Iterator i = this.buttons.iterator();
        while (i.hasNext()) {
            AbstractButton ab = (AbstractButton)i.next();
            if (ab.getModel() != model) continue;
            return ab;
        }
        return null;
    }

    public AbstractButton getSelected() {
        if (this.selectedButton == dummyButton) {
            return null;
        }
        return this.selectedButton;
    }

    public ButtonModel getSelection() {
        if (this.selectedButton == dummyButton) {
            return null;
        }
        return super.getSelection();
    }

    public boolean isSelected(AbstractButton button) {
        if (button == dummyButton) {
            return false;
        }
        return button == this.selectedButton;
    }

    public List getButtons() {
        LinkedList allButtons = new LinkedList(this.buttons);
        allButtons.remove(dummyButton);
        return Collections.unmodifiableList(allButtons);
    }

    public boolean contains(AbstractButton button) {
        if (button == dummyButton) {
            return false;
        }
        return this.buttons.contains(button);
    }

    public void clearSelection() {
        this.setSelected(dummyButton, true);
        this.selectedButton = dummyButton;
    }

    public int getButtonCount() {
        return Math.max(super.getButtonCount() - 1, 0);
    }
}

