/*
 * Decompiled with CFR 0.152.
 */
package com.levigo.util.swing;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.StringTokenizer;
import javax.swing.JComponent;
import javax.swing.JToolTip;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalToolTipUI;

public class MultiLineToolTip
extends JToolTip {
    public MultiLineToolTip() {
        this.setUI(new MultiLineToolTipUI());
    }

    public MultiLineToolTip(JComponent aComponent) {
        this();
        this.setComponent(aComponent);
    }

    class MultiLineToolTipUI
    extends MetalToolTipUI {
        private String[] toolTipTextLines;
        private Dimension nullSize = new Dimension(0, 0);
        private int marginWidth = 6;
        private int marginHeight = 6;

        MultiLineToolTipUI() {
        }

        public void paint(Graphics g, JComponent c) {
            FontMetrics aMetric = c.getFontMetrics(g.getFont());
            Dimension itsSize = c.getSize();
            g.setColor(UIManager.getColor("ToolTip.background"));
            g.fillRect(0, 0, itsSize.width, itsSize.height);
            g.setColor(UIManager.getColor("ToolTip.foreground"));
            if (this.toolTipTextLines != null) {
                for (int i = 0; i < this.toolTipTextLines.length; ++i) {
                    g.drawString(this.toolTipTextLines[i], 3, aMetric.getHeight() * (i + 1));
                }
            }
        }

        public Dimension getPreferredSize(JComponent c) {
            String toolTipText = ((JToolTip)c).getTipText();
            if (toolTipText == null) {
                this.toolTipTextLines = null;
                return this.nullSize;
            }
            if (c.getBorder() == null) {
                c.setBorder(UIManager.getBorder("ToolTip.border"));
            }
            FontMetrics aMetric = c.getFontMetrics(c.getFont());
            int maxLineWidth = 0;
            StringTokenizer st = new StringTokenizer(toolTipText, "\n");
            int lines = st.countTokens();
            this.toolTipTextLines = new String[lines];
            int i = 0;
            int width = 0;
            while (st.hasMoreTokens()) {
                this.toolTipTextLines[i] = (String)st.nextElement();
                maxLineWidth = maxLineWidth < (width = SwingUtilities.computeStringWidth(aMetric, this.toolTipTextLines[i++])) ? width : maxLineWidth;
            }
            return new Dimension(maxLineWidth + this.marginWidth, aMetric.getHeight() * lines + this.marginHeight);
        }
    }
}

