/*
 * Decompiled with CFR 0.152.
 */
package com.levigo.util.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.SystemColor;
import javax.swing.JComponent;

public class PaintLineComponent
extends JComponent {
    boolean topLinePainted = true;
    boolean leftLinePainted = true;
    boolean bottemLinePainted = true;
    boolean bottomLinePainted = true;
    boolean rightLinePainted = true;
    int emptyEdge = 0;
    Color lightColor = SystemColor.controlLtHighlight;
    Color darkColor = SystemColor.controlShadow;

    PaintLineComponent() {
    }

    public PaintLineComponent(boolean topPainted, boolean leftPainted, boolean bottomPainted, boolean rightPainted, int emptyEdgePercent) {
        this();
        this.topLinePainted = topPainted;
        this.leftLinePainted = leftPainted;
        this.bottomLinePainted = bottomPainted;
        this.rightLinePainted = rightPainted;
        if (emptyEdgePercent >= 0 && emptyEdgePercent <= 100) {
            this.emptyEdge = emptyEdgePercent;
        }
    }

    PaintLineComponent(Color firstColor, Color secondColor) {
        this();
        this.setColors(firstColor, secondColor);
    }

    public PaintLineComponent(boolean topPainted, boolean leftPainted, boolean bottomPainted, boolean rightPainted, int emptyEdgePercent, Color firstColor, Color secondColor) {
        this();
        this.topLinePainted = topPainted;
        this.leftLinePainted = leftPainted;
        this.bottomLinePainted = bottomPainted;
        this.rightLinePainted = rightPainted;
        if (emptyEdgePercent >= 0 && emptyEdgePercent <= 100) {
            this.emptyEdge = emptyEdgePercent;
        }
        this.setColors(firstColor, secondColor);
    }

    public void setColors(Color firstColor, Color secondColor) {
        if (firstColor != null) {
            this.lightColor = firstColor;
        }
        if (this.darkColor != null) {
            this.darkColor = secondColor;
        }
    }

    public void paint(Graphics g) {
        super.paint(g);
        Dimension mySize = this.getSize();
        int freeSpace = 0;
        if (this.topLinePainted) {
            freeSpace = this.emptyEdge * mySize.width / 100;
            g.setColor(this.lightColor);
            g.drawLine(freeSpace, 1, mySize.width - freeSpace, 1);
            g.setColor(this.darkColor);
            g.drawLine(freeSpace, 2, mySize.width - freeSpace, 2);
        }
        if (this.leftLinePainted) {
            freeSpace = this.emptyEdge * mySize.height / 100;
            g.setColor(this.lightColor);
            g.drawLine(1, freeSpace, 1, mySize.height - freeSpace);
            g.setColor(this.darkColor);
            g.drawLine(2, freeSpace, 2, mySize.height - freeSpace);
        }
        if (this.bottomLinePainted) {
            freeSpace = this.emptyEdge * mySize.width / 100;
            g.setColor(this.lightColor);
            g.drawLine(freeSpace, mySize.height - 1, mySize.width - freeSpace, mySize.height - 1);
            g.setColor(this.darkColor);
            g.drawLine(freeSpace, mySize.height - 2, mySize.width - freeSpace, mySize.height - 2);
        }
        if (this.rightLinePainted) {
            freeSpace = this.emptyEdge * mySize.height / 100;
            g.setColor(this.lightColor);
            g.drawLine(mySize.width - 1, freeSpace, mySize.width - 1, mySize.height - freeSpace);
            g.setColor(this.darkColor);
            g.drawLine(mySize.width - 2, freeSpace, mySize.width - 2, mySize.height - freeSpace);
        }
    }
}

