/*
 * Decompiled with CFR 0.152.
 */
package com.levigo.util.swing;

import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class PanelTitleBar
extends JComponent {
    private JLabel titleLabel;
    private static Image backgroundImageActive;
    private static Image backgroundImageInactive;
    private WindowFocusListener myListener;

    public PanelTitleBar(String title) {
        this.setLayout(new BoxLayout(this, 2));
        Border border = UIManager.getBorder("TitledPanel.titleBarBorder");
        this.setBorder(null != border ? border : BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.titleLabel = new JLabel(title);
        this.add(this.titleLabel);
        this.add(Box.createGlue());
        this.updateUI();
    }

    protected void paintComponent(Graphics g) {
        Window w = this.getWindow();
        g.drawImage(this.getBackgroundImage(null == w || w.isActive()), 0, 0, this.getWidth(), this.getHeight(), null, null);
        super.paintComponent(g);
    }

    private Image getBackgroundImage(boolean active) {
        if (active && null == backgroundImageActive || !active && null == backgroundImageInactive) {
            Color left = UIManager.getColor(active ? "InternalFrame.activeTitleBackground" : "InternalFrame.inactiveTitleBackground");
            Color right = UIManager.getColor(active ? "InternalFrame.activeTitleGradient" : "InternalFrame.inactiveTitleGradient");
            if (null == right) {
                right = UIManager.getColor("InternalFrame.inactiveTitleBackground");
            }
            int leaderWidth = 64;
            int[] imageData = new int[256 + leaderWidth];
            int v = (left.getRed() & 0xFF) << 16 | (left.getGreen() & 0xFF) << 8 | left.getBlue() & 0xFF;
            Arrays.fill(imageData, 0, leaderWidth, v);
            for (int i = 0; i < 256; ++i) {
                int r = (left.getRed() * (255 - i) + right.getRed() * i) / 255;
                int g = (left.getGreen() * (255 - i) + right.getGreen() * i) / 255;
                int b = (left.getBlue() * (255 - i) + right.getBlue() * i) / 255;
                imageData[i + leaderWidth] = (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
            }
            DirectColorModel cm = new DirectColorModel(24, 0xFF0000, 65280, 255, 0);
            BufferedImage i = new BufferedImage(cm, Raster.createWritableRaster(((ColorModel)cm).createCompatibleSampleModel(256, 1), new DataBufferInt(imageData, 256), null), false, null);
            if (active) {
                backgroundImageActive = i;
            } else {
                backgroundImageInactive = i;
            }
        }
        return active ? backgroundImageActive : backgroundImageInactive;
    }

    public void updateUI() {
        backgroundImageInactive = null;
        backgroundImageActive = null;
        this.titleLabel.setForeground(UIManager.getColor("InternalFrame.activeTitleForeground"));
        super.updateUI();
    }

    public void setTitle(String string) {
        this.titleLabel.setText(string);
    }

    public void addNotify() {
        super.addNotify();
        Window w = this.getWindow();
        if (null != w) {
            this.myListener = new WindowFocusListener(){

                public void windowLostFocus(WindowEvent e) {
                    PanelTitleBar.this.repaint();
                }

                public void windowGainedFocus(WindowEvent e) {
                    PanelTitleBar.this.repaint();
                }
            };
            w.addWindowFocusListener(this.myListener);
        }
    }

    public void removeNotify() {
        Window w;
        super.removeNotify();
        if (null != this.myListener && null != (w = this.getWindow())) {
            w.removeWindowFocusListener(this.myListener);
        }
    }

    private Window getWindow() {
        Container rootPaneParent = this.getRootPane().getParent();
        if (rootPaneParent instanceof Window) {
            return (Window)rootPaneParent;
        }
        return null;
    }
}

