/*
 * Decompiled with CFR 0.152.
 */
package com.levigo.util.swing;

import com.levigo.util.swing.SelectableNode;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class RadioButtonTree
extends JTree {
    public static final String BUTTON_STATE_PROPERTY = "ButtonValue";

    public RadioButtonTree(DefaultTreeModel model) {
        super(model);
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                TreePath p = RadioButtonTree.this.getPathForLocation(e.getX(), e.getY());
                RadioButtonTree.this.toggleRadioButton(p);
            }
        });
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if ((e.getKeyCode() == 32 || e.getKeyCode() == 10) && RadioButtonTree.this.getSelectionCount() == 1) {
                    RadioButtonTree.this.toggleRadioButton(RadioButtonTree.this.getSelectionPath());
                    e.consume();
                }
            }
        });
    }

    private void toggleRadioButton(TreePath path) {
        Object lastPathComponent = path.getLastPathComponent();
        if (lastPathComponent != null && lastPathComponent instanceof SelectableNode && ((SelectableNode)lastPathComponent).isSelectable()) {
            TreeNode parent;
            SelectableNode node;
            boolean wasSelected = (node = (SelectableNode)lastPathComponent).isSelected();
            node.setSelected(!wasSelected);
            ((DefaultTreeModel)this.getModel()).nodeChanged(node);
            if (!wasSelected && null != (parent = node.getParent())) {
                for (int ccount = parent.getChildCount() - 1; ccount >= 0; --ccount) {
                    TreeNode child = parent.getChildAt(ccount);
                    if (!(child instanceof SelectableNode) || child == node || !((SelectableNode)child).isSelected()) continue;
                    ((SelectableNode)child).setSelected(false);
                    ((DefaultTreeModel)this.getModel()).nodeChanged(node);
                }
            }
            this.firePropertyChange(BUTTON_STATE_PROPERTY, wasSelected, !wasSelected);
        }
    }

    public void setCellRenderer(TreeCellRenderer renderer) {
        super.setCellRenderer(new CheckBoxRenderDecorator(renderer));
    }

    private static class CheckBoxRenderDecorator
    implements TreeCellRenderer {
        private final TreeCellRenderer renderer;
        private JRadioButton button = new JRadioButton();
        private JPanel panel = new JPanel();

        public CheckBoxRenderDecorator(TreeCellRenderer parentRenderer) {
            this.renderer = parentRenderer;
            this.button.setText("");
            this.button.setOpaque(false);
            this.panel.setLayout(new BorderLayout());
            this.panel.setOpaque(false);
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Component c = this.renderer.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            if (value instanceof SelectableNode && ((SelectableNode)value).isSelectable()) {
                this.button.setSelected(((SelectableNode)value).isSelected());
                this.panel.removeAll();
                this.panel.add((Component)this.button, "West");
                this.panel.add(c, "East");
                c = this.panel;
            }
            return c;
        }
    }
}

