/*
 * Decompiled with CFR 0.152.
 */
package com.levigo.util.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JButton;
import javax.swing.JToggleButton;
import javax.swing.border.BevelBorder;

public class SlickBevelBorder
extends BevelBorder {
    private static SlickBevelBorder loweredBevelBorder = new SlickBevelBorder(1);
    private static SlickBevelBorder raisedBevelBorder = new SlickBevelBorder(0);
    public static int AUTO_ROLLOVER = 64;
    public static int AUTO_SELECT = 128;
    public static int AUTO_DISABLE = 256;

    public SlickBevelBorder(int bevelType) {
        super(bevelType);
    }

    public SlickBevelBorder(int bevelType, Color highlight, Color shadow) {
        super(bevelType, highlight, shadow);
    }

    public SlickBevelBorder(int bevelType, Color highlightOuterColor, Color highlightInnerColor, Color shadowOuterColor, Color shadowInnerColor) {
        super(bevelType, highlightOuterColor, highlightInnerColor, shadowOuterColor, shadowInnerColor);
    }

    public static SlickBevelBorder getLoweredBevelBorder() {
        return loweredBevelBorder;
    }

    public static SlickBevelBorder getRaisedBevelBorder() {
        return raisedBevelBorder;
    }

    public Insets getBorderInsets(Component c, Insets insets) {
        insets.bottom = 1;
        insets.right = 1;
        insets.top = 1;
        insets.left = 1;
        return insets;
    }

    public Insets getBorderInsets(Component c) {
        return new Insets(1, 1, 1, 1);
    }

    protected void paintLoweredBevel(Component c, Graphics g, int x, int y, int width, int height) {
        Color oldColor = g.getColor();
        int h = height;
        int w = width;
        g.translate(x, y);
        g.setColor(c.getBackground().darker());
        g.drawLine(0, 0, 0, h - 1);
        g.drawLine(1, 0, w - 1, 0);
        g.setColor(c.getBackground().brighter());
        g.drawLine(1, h - 1, w - 1, h - 1);
        g.drawLine(w - 1, 1, w - 1, h - 2);
        g.translate(-x, -y);
        g.setColor(oldColor);
    }

    protected void paintRaisedBevel(Component c, Graphics g, int x, int y, int width, int height) {
        Color oldColor = g.getColor();
        int h = height;
        int w = width;
        g.translate(x, y);
        g.setColor(c.getBackground().brighter());
        g.drawLine(0, 0, 0, h - 1);
        g.drawLine(1, 0, w - 1, 0);
        g.setColor(c.getBackground().darker());
        g.drawLine(1, h - 1, w - 1, h - 1);
        g.drawLine(w - 1, 1, w - 1, h - 2);
        g.translate(-x, -y);
        g.setColor(oldColor);
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        switch (this.bevelType) {
            case 0: {
                this.paintRaisedBevel(c, g, x, y, width, height);
                break;
            }
            case 1: {
                this.paintLoweredBevel(c, g, x, y, width, height);
                break;
            }
            default: {
                if (c instanceof JButton) {
                    JButton b;
                    if ((this.bevelType & AUTO_SELECT) != 0 && (b = (JButton)c).getModel().isPressed() && b.getModel().isArmed()) {
                        this.paintLoweredBevel(c, g, x, y, width, height);
                        break;
                    }
                    if ((this.bevelType & AUTO_ROLLOVER) != 0) {
                        b = (JButton)c;
                        if (!b.isRolloverEnabled() || !b.getModel().isRollover()) break;
                        this.paintRaisedBevel(c, g, x, y, width, height);
                        break;
                    }
                    this.paintRaisedBevel(c, g, x, y, width, height);
                    break;
                }
                if (c instanceof JToggleButton) {
                    JToggleButton b;
                    if ((this.bevelType & AUTO_SELECT) != 0 && ((b = (JToggleButton)c).getModel().isSelected() || b.getModel().isPressed() && b.getModel().isArmed())) {
                        this.paintLoweredBevel(c, g, x, y, width, height);
                        break;
                    }
                    if ((this.bevelType & AUTO_ROLLOVER) != 0) {
                        b = (JToggleButton)c;
                        if (!b.isRolloverEnabled() || !b.getModel().isRollover()) break;
                        this.paintRaisedBevel(c, g, x, y, width, height);
                        break;
                    }
                    this.paintRaisedBevel(c, g, x, y, width, height);
                    break;
                }
                this.paintRaisedBevel(c, g, x, y, width, height);
            }
        }
    }
}

