/*
 * Decompiled with CFR 0.152.
 */
package com.levigo.util.swing;

import com.levigo.util.log.Log;
import java.lang.reflect.InvocationTargetException;
import java.util.Vector;
import javax.swing.SwingUtilities;

class TGASwingUtilWorkerThreads {
    static String LOG_CONTEXT = "TGASwingUtilWorkerThreads$ExceutionQueue";
    static long instanceID = 0L;
    private ExecutionQueue asyncWorker = null;
    private ExecutionQueue syncWorker = null;

    TGASwingUtilWorkerThreads(ThreadGroup tg) {
        this.asyncWorker = new ExecutionQueue(tg, false);
        this.asyncWorker.start();
        this.syncWorker = new ExecutionQueue(tg, true);
        this.syncWorker.start();
    }

    void invokeLater(Runnable r) {
        this.asyncWorker.queueWork(r);
    }

    Throwable invokeAndWait(Runnable r) {
        return this.syncWorker.execute(r);
    }

    void destroy() {
        Log.debug((String)LOG_CONTEXT, (String)"destroy()");
        this.asyncWorker.setRunning(false);
        this.syncWorker.setRunning(false);
    }

    public String toString() {
        if (null != this.asyncWorker && null != this.syncWorker) {
            return "TGASwingUtilWorkerThreads: " + this.asyncWorker.getName() + "+" + this.syncWorker.getName();
        }
        return "TGASwingUtilWorkerThreads";
    }

    class ExecutionQueue
    extends Thread {
        private Vector queue;
        private boolean sync;
        boolean running;

        ExecutionQueue(ThreadGroup tg, boolean synchronous) {
            super(tg, "TGAWorkerThread-" + instanceID++ + "-sync[" + synchronous + "]");
            this.queue = null;
            this.sync = true;
            this.running = true;
            this.queue = new Vector();
            this.sync = synchronous;
        }

        void queueWork(Runnable r) {
            Log.debug((String)LOG_CONTEXT, (String)("> queueWork - " + Thread.currentThread().getName() + ": entered: " + r.toString()));
            this.addRunnable(r);
            Log.debug((String)LOG_CONTEXT, (String)("> queueWork - " + Thread.currentThread().getName() + ": exiting: " + r.toString()));
        }

        Throwable execute(Runnable r) {
            Log.debug((String)LOG_CONTEXT, (String)("> execute - " + Thread.currentThread().getName() + ": entered: " + r.toString()));
            WorkItemWrapper wrapper = this.addRunnable(r);
            Log.debug((String)LOG_CONTEXT, (String)("> execute - " + Thread.currentThread().getName() + ": added Runnable: " + r.toString()));
            wrapper.waitTillDone();
            Log.debug((String)LOG_CONTEXT, (String)("> execute - " + Thread.currentThread().getName() + ": exiting: " + r.toString()));
            return wrapper.getThrowable();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Log.debug((String)LOG_CONTEXT, (String)("< run: " + Thread.currentThread().getName() + ": entered run method."));
            while (this.isRunning()) {
                WorkItemWrapper workItem = null;
                Log.debug((String)LOG_CONTEXT, (String)("< run: " + Thread.currentThread().getName() + ": looping in run, entering synchronized block."));
                ExecutionQueue executionQueue = this;
                synchronized (executionQueue) {
                    while (this.queue.size() == 0 && this.isRunning()) {
                        try {
                            Log.debug((String)LOG_CONTEXT, (String)("< run: " + Thread.currentThread().getName() + ": about to wait."));
                            this.wait();
                            Log.debug((String)LOG_CONTEXT, (String)("< run: " + Thread.currentThread().getName() + ": finished waiting."));
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    if (this.queue.size() > 0) {
                        Log.debug((String)LOG_CONTEXT, (String)("< run: " + Thread.currentThread().getName() + ": queue size: " + this.queue.size()));
                        workItem = (WorkItemWrapper)this.queue.remove(0);
                        Log.debug((String)LOG_CONTEXT, (String)("< run: " + Thread.currentThread().getName() + ": removed work item: " + workItem.toString()));
                    }
                }
                Log.debug((String)LOG_CONTEXT, (String)("< run: " + Thread.currentThread().getName() + ": exiting synchronized block."));
                if (null != workItem) {
                    try {
                        if (this.sync) {
                            Log.debug((String)LOG_CONTEXT, (String)("< run: " + Thread.currentThread().getName() + ": about to call SwingUtilities.invokeAndWait() for: " + workItem.toString()));
                            SwingUtilities.invokeAndWait(workItem.getWork());
                            Log.debug((String)LOG_CONTEXT, (String)("< run: " + Thread.currentThread().getName() + ": finished calling SwingUtilities.invokeAndWait() for: " + workItem.toString()));
                            Log.debug((String)LOG_CONTEXT, (String)("< run: " + Thread.currentThread().getName() + ": entered synchronized block, about to call notify for: " + workItem.toString()));
                            Log.debug((String)LOG_CONTEXT, (String)("< run: " + Thread.currentThread().getName() + ": about to leave synchronized block, finished calling notify for: " + workItem.toString()));
                            Log.debug((String)LOG_CONTEXT, (String)("< run: " + Thread.currentThread().getName() + ": left synchronized block: " + workItem.toString()));
                        } else {
                            SwingUtilities.invokeLater(workItem.getWork());
                        }
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    catch (InvocationTargetException e) {
                        workItem.setThrowable(e.getTargetException());
                        e.printStackTrace();
                    }
                    finally {
                        workItem.done();
                    }
                }
                Log.debug((String)LOG_CONTEXT, (String)("< run: " + Thread.currentThread().getName() + ": finished loop cycle."));
            }
            Log.debug((String)LOG_CONTEXT, (String)("< run: " + Thread.currentThread().getName() + ": leaving run method."));
        }

        synchronized WorkItemWrapper addRunnable(Runnable r) {
            WorkItemWrapper wrapper = new WorkItemWrapper(r);
            this.queue.add(wrapper);
            this.notify();
            return wrapper;
        }

        synchronized boolean isRunning() {
            return this.running;
        }

        synchronized void setRunning(boolean running) {
            this.running = running;
            this.notify();
        }
    }

    private static class WorkItemWrapper {
        private final Runnable item;
        private Throwable throwable;
        private boolean done = false;

        WorkItemWrapper(Runnable item) {
            this.item = item;
        }

        private synchronized void waitTillDone() {
            while (!this.done) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }

        private synchronized void done() {
            this.done = true;
            this.notify();
        }

        private Runnable getWork() {
            return this.item;
        }

        public String toString() {
            return this.item.toString();
        }

        private Throwable getThrowable() {
            return this.throwable;
        }

        private void setThrowable(Throwable throwable) {
            this.throwable = throwable;
        }
    }
}

