/*
 * Decompiled with CFR 0.152.
 */
package com.levigo.util.swing.action;

import com.levigo.util.swing.action.AbstractCommand;
import com.levigo.util.swing.action.Command;
import com.levigo.util.swing.action.CommandFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;

public class DefaultCommandFactory
implements CommandFactory {
    static final String DEFAULT_PROPERTIES_FILE = "commands.properties";
    private HashMap commandCache = new HashMap();
    private Properties commandLookupProperties = new Properties();
    private static HashMap commandFactoryCache = new HashMap();

    private DefaultCommandFactory(String propertiesFileName) throws Exception {
        this.loadProperties(propertiesFileName);
    }

    public Command getCommand(String key) {
        Command askedCommand = null;
        if (this.commandCache.containsKey(key)) {
            askedCommand = (Command)this.commandCache.get(key);
        }
        if (askedCommand == null) {
            String className;
            if ((key = key.trim()).lastIndexOf(".") >= 0) {
                key = key.substring(key.lastIndexOf(".") + 1).trim();
            }
            className = (className = this.commandLookupProperties.getProperty(key)) != null ? className.trim() : "";
            try {
                Class<?> commandClass = Class.forName(className);
                if (AbstractCommand.class.isAssignableFrom(commandClass)) {
                    askedCommand = (AbstractCommand)commandClass.newInstance();
                    ((AbstractCommand)askedCommand).setKey(key);
                    ArrayList<String> allParameters = new ArrayList<String>();
                    String parameter = null;
                    int mistakenHits = 0;
                    int i = 0;
                    while (mistakenHits < 3) {
                        parameter = this.commandLookupProperties.getProperty(key + ".param." + i);
                        if (parameter != null) {
                            mistakenHits = 0;
                            allParameters.add(parameter.trim());
                        } else {
                            allParameters.add("");
                            ++mistakenHits;
                        }
                        ++i;
                    }
                    ((AbstractCommand)askedCommand).setCommandParameters(allParameters.toArray(new String[allParameters.size()]));
                }
            }
            catch (Exception exp) {
                System.err.println("Key: " + key + " No Command was found for the Class '" + className + "'");
                exp.printStackTrace();
                return null;
            }
            this.commandCache.put(key, askedCommand);
        }
        return askedCommand;
    }

    public static CommandFactory getInstance(String propertiesFileName) {
        CommandFactory instance;
        if (propertiesFileName == null) {
            propertiesFileName = DEFAULT_PROPERTIES_FILE;
        }
        if (null == (instance = (CommandFactory)commandFactoryCache.get(propertiesFileName))) {
            try {
                instance = new DefaultCommandFactory(propertiesFileName);
            }
            catch (Exception exp) {
                exp.printStackTrace();
                instance = null;
            }
            commandFactoryCache.put(propertiesFileName, instance);
        }
        return instance;
    }

    private void loadProperties(String propertiesFileName) throws IOException {
        InputStream is = this.getClass().getResourceAsStream(propertiesFileName);
        this.loadProperties(is);
    }

    private void loadProperties(InputStream is) throws IOException {
        this.commandLookupProperties.load(is);
        is.close();
    }
}

