/*
 * Decompiled with CFR 0.152.
 */
package com.levigo.util.swing.action;

import com.levigo.util.configuration.PropertiesConfigurationImpl;
import com.levigo.util.swing.JButtonGroup;
import com.levigo.util.swing.LevigoSeparators;
import com.levigo.util.swing.action.ActionFactory;
import com.levigo.util.swing.action.ActionJCheckboxMenuItem;
import com.levigo.util.swing.action.ActionJRadioMenuItem;
import com.levigo.util.swing.action.CommandAction;
import com.levigo.util.swing.action.Context;
import com.levigo.util.swing.action.DefaultActionFactory;
import com.levigo.util.swing.action.IconJMenuItem;
import com.levigo.util.swing.action.MenuComponentFactory;
import com.levigo.util.swing.action.NonUglyActionJToggleButton;
import com.levigo.util.swing.action.PopupJToggleButton;
import com.levigo.util.swing.action.VisibilityEnabledJCheckboxMenuItem;
import com.levigo.util.swing.action.VisibilityEnabledJMenuItem;
import com.levigo.util.swing.action.VisibilityEnabledJRadioMenuItem;
import com.levigo.util.swing.toolbar.EllipseJToolBar;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;

public class DefaultMenuComponentFactory
implements MenuComponentFactory {
    static final String CHECKBOX_MENU = "checkbox";
    static final String VISIBILITY_CHECKBOX_MENU = "visibilityEnabledCheckbox";
    static final String VISIBILITY_RADIOBUTTON_MENU = "visibilityEnabledRadiobutton";
    static final String RADIOBUTTON_MENU = "radiobutton";
    static final String ICON_MENU = "iconmenu";
    static final String VISIBILITY_MENU = "visibilityEnabled";
    static final String SELECTED_MENU = "selected";
    private static HashMap menuComponentFactoryCache = new HashMap();
    private PropertiesConfigurationImpl compositionLookupProperties = new PropertiesConfigurationImpl();
    static String DEFAULT_PROPERTIES_FILE = "menucomponents.properties";
    private static String ACTIONS = ".actions";
    private static String MENU_ACTIONS = ".menu";
    private static String CONTEXT_MENU_ACTIONS = ".contextmenu";
    private static String TOOLBAR_ACTIONS = ".toolbar";
    private static String TEXT = ".name";
    private static String SUBMENU_ACTION = ".action";
    private static String MNEMONICKEY = ".MnemonicKey";
    private static String SEPARATOR = "|";
    private static String SUBMENUVARIABLE = "{>";
    private static String VARIABLE = "{";
    private static final String EXTERNAL_ACTION = "$";
    private static String STARTSUB = "{StartSubMenu=";
    private static String ENDSUB = "{EndSubMenu=";

    private DefaultMenuComponentFactory(String propertiesFileName) throws Exception {
        this.loadProperties(propertiesFileName);
    }

    public JToolBar getToolbar(String key, Context context) {
        return this.doCreateToolbar(this.getStructureOfActionNames(key, TOOLBAR_ACTIONS), context, null);
    }

    public JToolBar getToolbar(String key, Context context, Action[] additionalActions) {
        return this.doCreateToolbar(this.getStructureOfActionNames(key, TOOLBAR_ACTIONS), context, additionalActions);
    }

    public JMenu getMenu(String key, Context context) {
        return this.getMenu(key, context, null);
    }

    public JMenu getMenu(String key, Context context, Action[] additionalActions) {
        return this.doCreateMenu(key, this.getStructureOfActionNames(key, MENU_ACTIONS), context, additionalActions);
    }

    public JPopupMenu getContextMenu(String key, Context context) {
        return this.getContextMenu(key, context, null);
    }

    public JPopupMenu getContextMenu(String key, Context context, Action[] additionalActions) {
        return this.doCreateContextMenu(key, this.getStructureOfActionNames(key, CONTEXT_MENU_ACTIONS), context, additionalActions);
    }

    private ActionFactory getActionFactory(String key) {
        String sourceName = null;
        int index = key.indexOf(46);
        sourceName = index < 0 ? this.compositionLookupProperties.getProperty("resource.actions.default") : key.substring(0, index);
        String parameter = this.compositionLookupProperties.getProperty("resource." + sourceName);
        return DefaultActionFactory.getInstance(parameter);
    }

    public Collection getActions(String key) {
        return this.getStructureOfActionNames(key, ACTIONS);
    }

    public Collection getCommandActions(String key, Context context) {
        Collection actionNames = this.getActions(key);
        ArrayList<CommandAction> allActions = new ArrayList<CommandAction>();
        if (actionNames != null) {
            Iterator it = actionNames.iterator();
            while (it.hasNext()) {
                CommandAction anAction;
                Object nextAction = it.next();
                if (!(nextAction instanceof String) || (anAction = this.getActionFactory((String)nextAction).getAction(context, (String)nextAction)) == null) continue;
                allActions.add(anAction);
            }
        }
        return allActions;
    }

    private JToolBar doCreateToolbar(Collection actionCollection, Context context, Action[] additionalActions) {
        if (actionCollection == null) {
            return null;
        }
        EllipseJToolBar toolBar = new EllipseJToolBar();
        Action action = null;
        String metaInfo = null;
        Object nextIter = null;
        Iterator actionIterator = actionCollection.iterator();
        while (actionIterator.hasNext()) {
            nextIter = actionIterator.next();
            action = null;
            if (nextIter instanceof CommandAction) {
                System.out.println("Gibt's das?? " + nextIter + " ist ne Action. Tsts.");
                action = nextIter;
            } else {
                metaInfo = nextIter;
                if (metaInfo.startsWith(STARTSUB)) {
                    String popupActionName = metaInfo.substring(metaInfo.indexOf("=") + 1).trim();
                    JPopupMenu popupMenu = null;
                    ArrayList<String> subMenuCollection = new ArrayList<String>();
                    subMenuCollection.clear();
                    while (actionIterator.hasNext() && !(metaInfo = (String)actionIterator.next()).equals(ENDSUB + popupActionName)) {
                        subMenuCollection.add(metaInfo);
                    }
                    popupMenu = this.doCreateContextMenu(popupActionName, subMenuCollection, context, additionalActions);
                    if (popupMenu != null) {
                        popupMenu.setName(popupActionName);
                    }
                    if ((action = this.getActionFactory(metaInfo).getAction(context, popupActionName)) != null) {
                        toolBar.add(new PopupJToggleButton(action, popupMenu));
                    }
                    action = null;
                } else if (!metaInfo.startsWith(ENDSUB)) {
                    if (metaInfo.startsWith(SEPARATOR)) {
                        toolBar.add(LevigoSeparators.createSingleLineSeparator(2));
                    } else if (metaInfo.startsWith(EXTERNAL_ACTION)) {
                        if (additionalActions != null) {
                            String nextActionName = metaInfo.substring(1);
                            for (int i = 0; i < additionalActions.length; ++i) {
                                if (additionalActions[i] == null || !additionalActions[i].getValue("Name").equals(nextActionName)) continue;
                                action = additionalActions[i];
                                this.putValuesInAdditionalActions(context, action, metaInfo);
                                break;
                            }
                        }
                    } else {
                        action = this.getActionFactory(metaInfo).getAction(context, metaInfo);
                    }
                }
            }
            if (null == action) continue;
            toolBar.add(this.doCreateComponentForAction(action));
        }
        return toolBar;
    }

    private void putValuesInAdditionalActions(Context context, Action action, String metaInfo) {
        CommandAction dummyAction = this.getActionFactory(metaInfo).getAction(context, metaInfo);
        if (dummyAction != null) {
            if (dummyAction.getValue("ShortDescription") != null && !dummyAction.getValue("ShortDescription").equals("")) {
                action.putValue("ShortDescription", dummyAction.getValue("ShortDescription"));
            }
            if (dummyAction.getValue("LongDescription") != null && !dummyAction.getValue("LongDescription").equals("")) {
                action.putValue("LongDescription", dummyAction.getValue("LongDescription"));
            }
            if (dummyAction.getValue("SmallIcon") != null) {
                action.putValue("SmallIcon", dummyAction.getValue("SmallIcon"));
            }
            if (dummyAction.getValue("AcceleratorKey") != null) {
                action.putValue("AcceleratorKey", dummyAction.getValue("AcceleratorKey"));
            }
            if (dummyAction.getValue("MnemonicKey") != null) {
                action.putValue("MnemonicKey", dummyAction.getValue("MnemonicKey"));
            }
        }
    }

    protected JComponent doCreateComponentForAction(Action action) {
        if (null != action.getValue("SmallIcon")) {
            return new NonUglyActionJToggleButton(action);
        }
        return new JButton(action);
    }

    private JMenu doCreateMenu(String key, Collection actionCollection, Context context, Action[] additionalActions) {
        if (actionCollection == null) {
            return null;
        }
        String menuName = null;
        String mnemonicKey = null;
        if (key != null && (menuName = this.compositionLookupProperties.getProperty(key + ACTIONS + TEXT, null)) == null) {
            menuName = this.compositionLookupProperties.getProperty(key + TEXT, null);
            mnemonicKey = this.compositionLookupProperties.getProperty(key + MNEMONICKEY, null);
        }
        if (menuName == null) {
            menuName = "";
        }
        JMenu menu = new JMenu(menuName);
        if (null != mnemonicKey && mnemonicKey.length() > 0) {
            menu.setMnemonic(mnemonicKey.charAt(0));
        }
        ActionJCheckboxMenuItem chckMenu = null;
        ActionJRadioMenuItem radioMenu = null;
        ButtonGroup group = new ButtonGroup();
        Action action = null;
        ArrayList<String> subMenuCollection = new ArrayList<String>();
        String metaInfo = null;
        Iterator actionIterator = actionCollection.iterator();
        while (actionIterator.hasNext()) {
            Object nextIter = actionIterator.next();
            action = null;
            if (nextIter instanceof CommandAction) {
                action = (CommandAction)nextIter;
            } else {
                metaInfo = (String)nextIter;
                if (metaInfo.startsWith(STARTSUB)) {
                    String subMenuName = metaInfo.substring(metaInfo.indexOf("=") + 1).trim();
                    JMenu subMenu = null;
                    subMenuCollection.clear();
                    while (actionIterator.hasNext() && !(metaInfo = (String)actionIterator.next()).equals(ENDSUB + subMenuName)) {
                        subMenuCollection.add(metaInfo);
                    }
                    subMenu = this.doCreateMenu(null, subMenuCollection, context, additionalActions);
                    if (subMenu != null) {
                        subMenu.setName(subMenuName);
                        subMenu.setText(subMenuName);
                        menu.add(subMenu);
                    }
                } else if (metaInfo.equals(SEPARATOR)) {
                    menu.addSeparator();
                } else if (metaInfo.startsWith(EXTERNAL_ACTION)) {
                    if (additionalActions != null) {
                        String nextActionName = metaInfo.substring(1);
                        for (int i = 0; i < additionalActions.length; ++i) {
                            if (additionalActions[i] == null || !additionalActions[i].getValue("Name").equals(nextActionName)) continue;
                            action = additionalActions[i];
                            this.putValuesInAdditionalActions(context, action, metaInfo);
                            break;
                        }
                    }
                } else {
                    action = this.getActionFactory(metaInfo).getAction(context, metaInfo);
                }
            }
            if (null == action) continue;
            String menuType = (String)action.getValue("menuType");
            String menuState = (String)action.getValue("menuState");
            if (menuType != null && menuType.equals(CHECKBOX_MENU)) {
                chckMenu = new ActionJCheckboxMenuItem(action);
                if (menuState != null) {
                    chckMenu.setSelected(menuState.equals(SELECTED_MENU));
                }
                menu.add(chckMenu).setIcon(null);
                continue;
            }
            if (menuType != null && menuType.equals(VISIBILITY_CHECKBOX_MENU)) {
                chckMenu = new VisibilityEnabledJCheckboxMenuItem(action);
                if (menuState != null) {
                    chckMenu.setSelected(menuState.equals(SELECTED_MENU));
                }
                menu.add(chckMenu).setIcon(null);
                continue;
            }
            if (menuType != null && menuType.equals(RADIOBUTTON_MENU)) {
                radioMenu = new ActionJRadioMenuItem(action);
                if (menuState != null) {
                    radioMenu.setSelected(menuState.equals(SELECTED_MENU));
                }
                group.add(radioMenu);
                menu.add(radioMenu).setIcon(null);
                continue;
            }
            if (menuType != null && menuType.equals(VISIBILITY_RADIOBUTTON_MENU)) {
                radioMenu = new VisibilityEnabledJRadioMenuItem(action);
                if (menuState != null) {
                    radioMenu.setSelected(menuState.equals(SELECTED_MENU));
                }
                group.add(radioMenu);
                menu.add(radioMenu).setIcon(null);
                continue;
            }
            if (menuType != null && menuType.equals(VISIBILITY_MENU)) {
                menu.add(new VisibilityEnabledJMenuItem(action));
                continue;
            }
            menu.add(new IconJMenuItem(action, menuType != null && menuType.equals(ICON_MENU)));
        }
        return menu;
    }

    private JPopupMenu doCreateContextMenu(String key, Collection actionCollection, Context context, Action[] additionalActions) {
        if (actionCollection == null) {
            return null;
        }
        JPopupMenu menu = new JPopupMenu();
        ActionJCheckboxMenuItem chckMenu = null;
        ActionJRadioMenuItem radioMenu = null;
        JButtonGroup group = null;
        Action action = null;
        ArrayList<String> subMenuCollection = new ArrayList<String>();
        String metaInfo = null;
        Iterator actionIterator = actionCollection.iterator();
        while (actionIterator.hasNext()) {
            Object nextIter = actionIterator.next();
            action = null;
            if (nextIter instanceof CommandAction) {
                action = (CommandAction)nextIter;
            } else {
                metaInfo = (String)nextIter;
                if (metaInfo.startsWith(STARTSUB)) {
                    String subMenuName = metaInfo.substring(metaInfo.indexOf("=") + 1).trim();
                    JMenu subMenu = null;
                    subMenuCollection.clear();
                    while (actionIterator.hasNext() && !(metaInfo = (String)actionIterator.next()).equals(ENDSUB + subMenuName)) {
                        subMenuCollection.add(metaInfo);
                    }
                    subMenu = this.doCreateMenu(null, subMenuCollection, context, additionalActions);
                    if (subMenu != null) {
                        subMenu.setName(subMenuName);
                        subMenu.setText(subMenuName);
                        menu.add(subMenu);
                    }
                } else if (metaInfo.equals(SEPARATOR)) {
                    menu.addSeparator();
                } else if (metaInfo.startsWith(EXTERNAL_ACTION)) {
                    if (additionalActions != null) {
                        String nextActionName = metaInfo.substring(1);
                        for (int i = 0; i < additionalActions.length; ++i) {
                            if (additionalActions[i] == null || !additionalActions[i].getValue("Name").equals(nextActionName)) continue;
                            action = additionalActions[i];
                            this.putValuesInAdditionalActions(context, action, metaInfo);
                            break;
                        }
                    }
                } else {
                    action = this.getActionFactory(metaInfo).getAction(context, metaInfo);
                }
            }
            if (null == action) continue;
            String menuType = (String)action.getValue("menuType");
            String menuState = (String)action.getValue("menuState");
            if (menuType != null && menuType.equals(CHECKBOX_MENU)) {
                chckMenu = new ActionJCheckboxMenuItem(action);
                if (menuState != null) {
                    chckMenu.setSelected(menuState.equals(SELECTED_MENU));
                }
                menu.add(chckMenu).setIcon(null);
                continue;
            }
            if (menuType != null && menuType.equals(VISIBILITY_CHECKBOX_MENU)) {
                chckMenu = new VisibilityEnabledJCheckboxMenuItem(action);
                if (menuState != null) {
                    chckMenu.setSelected(menuState.equals(SELECTED_MENU));
                }
                menu.add(chckMenu).setIcon(null);
                continue;
            }
            if (menuType != null && menuType.equals(RADIOBUTTON_MENU)) {
                radioMenu = new ActionJRadioMenuItem(action);
                if (menuState != null) {
                    radioMenu.setSelected(menuState.equals(SELECTED_MENU));
                }
                if (group == null) {
                    group = new JButtonGroup();
                    menu.putClientProperty("ButtonGroup", group);
                }
                group.add(radioMenu);
                menu.add(radioMenu).setIcon(null);
                continue;
            }
            if (menuType != null && menuType.equals(VISIBILITY_RADIOBUTTON_MENU)) {
                radioMenu = new VisibilityEnabledJRadioMenuItem(action);
                if (menuState != null) {
                    radioMenu.setSelected(menuState.equals(SELECTED_MENU));
                }
                if (group == null) {
                    group = new JButtonGroup();
                    menu.putClientProperty("ButtonGroup", group);
                }
                group.add(radioMenu);
                menu.add(radioMenu).setIcon(null);
                continue;
            }
            if (menuType != null && menuType.equals(VISIBILITY_MENU)) {
                menu.add(new VisibilityEnabledJMenuItem(action));
                continue;
            }
            boolean withIcon = menuType != null && menuType.equals(ICON_MENU) || this.compositionLookupProperties.getPropertyAsBoolean(key + ".enableIcons", false);
            menu.add(new IconJMenuItem(action, withIcon));
        }
        return menu;
    }

    public static DefaultMenuComponentFactory getInstance(String propertiesFileName) {
        DefaultMenuComponentFactory instance;
        if (propertiesFileName == null) {
            propertiesFileName = DEFAULT_PROPERTIES_FILE;
        }
        if (null == (instance = (DefaultMenuComponentFactory)menuComponentFactoryCache.get(propertiesFileName))) {
            try {
                instance = new DefaultMenuComponentFactory(propertiesFileName);
            }
            catch (Exception exp) {
                exp.printStackTrace();
                instance = null;
            }
            menuComponentFactoryCache.put(propertiesFileName, instance);
        }
        return instance;
    }

    private DefaultMenuComponentFactory getMenuFactory(String key) {
        String sourceName = null;
        String resourcePath = null;
        int index = key.indexOf(46);
        if (index < 0) {
            return this;
        }
        sourceName = key.substring(0, index - 1);
        resourcePath = this.compositionLookupProperties.getProperty("resource." + sourceName);
        return DefaultMenuComponentFactory.getInstance(resourcePath);
    }

    private Collection getStructureOfActionNames(String key, String type) {
        String exp;
        int indexComma = key.indexOf(46);
        if (indexComma >= 0) {
            key = key.substring(0, indexComma - 1);
        }
        if ((exp = this.compositionLookupProperties.getProperty(key + ACTIONS + type, null)) == null) {
            exp = this.compositionLookupProperties.getProperty(key + ACTIONS);
        }
        if (exp == null) {
            System.out.println("A definition for the key \"" + key + "\" was not found in the file of menu definitions!");
            return null;
        }
        StringTokenizer actionsToken = new StringTokenizer(exp, ",", false);
        ArrayList<String> actionsCollection = new ArrayList<String>();
        String token = null;
        ArrayList<String> nameOfSubmenu = new ArrayList<String>();
        while (actionsToken.hasMoreTokens()) {
            token = actionsToken.nextToken().trim();
            if (token == null || token.trim().length() == 0) continue;
            if (token.startsWith(VARIABLE)) {
                if (token.startsWith(SUBMENUVARIABLE)) {
                    token = token.substring(SUBMENUVARIABLE.length(), token.length() - 1).trim();
                    nameOfSubmenu.add(this.compositionLookupProperties.getProperty(token + TEXT, this.compositionLookupProperties.getProperty(token + SUBMENU_ACTION, "Not Found!")));
                    actionsCollection.add(STARTSUB + nameOfSubmenu.get(nameOfSubmenu.size() - 1));
                    Collection subMenu = null;
                    subMenu = this.getMenuFactory(token).getStructureOfActionNames(token, type);
                    if (subMenu != null) {
                        actionsCollection.addAll(subMenu);
                    }
                    actionsCollection.add(ENDSUB + nameOfSubmenu.get(nameOfSubmenu.size() - 1));
                    nameOfSubmenu.remove(nameOfSubmenu.size() - 1);
                    continue;
                }
                Collection anotherMenuPart = this.getMenuFactory(token = token.substring(VARIABLE.length(), token.length() - 1).trim()).getStructureOfActionNames(token, type);
                if (anotherMenuPart == null) continue;
                actionsCollection.addAll(anotherMenuPart);
                continue;
            }
            if (token.length() <= 0) continue;
            actionsCollection.add(token);
        }
        return actionsCollection;
    }

    private void loadProperties(String propertiesFileName) throws IOException {
        this.compositionLookupProperties.load(propertiesFileName, this.getClass());
    }

    public JMenuBar getMenuBar(String key, Context context) {
        return this.doCreateMenuBar(key, this.getStructureOfActionNames(key, MENU_ACTIONS), context, null);
    }

    private JMenuBar doCreateMenuBar(String key, Collection actionCollection, Context context, Action[] additionalActions) {
        if (actionCollection == null) {
            return null;
        }
        String menuName = null;
        if (key != null && (menuName = this.compositionLookupProperties.getProperty(key + ACTIONS + TEXT, null)) == null) {
            menuName = this.compositionLookupProperties.getProperty(key + TEXT, null);
        }
        if (menuName == null) {
            menuName = "";
        }
        JMenuBar menuBar = new JMenuBar();
        Iterator actionIterator = actionCollection.iterator();
        while (actionIterator.hasNext()) {
            Object nextIter = actionIterator.next();
            Action action = null;
            if (nextIter instanceof CommandAction) {
                action = (CommandAction)nextIter;
            } else {
                String metaInfo = (String)nextIter;
                if (metaInfo.startsWith(EXTERNAL_ACTION)) {
                    if (additionalActions != null) {
                        String nextActionName = metaInfo.substring(1);
                        for (int i = 0; i < additionalActions.length; ++i) {
                            if (additionalActions[i] == null || !additionalActions[i].getValue("Name").equals(nextActionName)) continue;
                            action = additionalActions[i];
                            this.putValuesInAdditionalActions(context, action, metaInfo);
                            break;
                        }
                    }
                } else {
                    String name = metaInfo.trim();
                    String menuTitle = this.compositionLookupProperties.getProperty(name + TEXT, menuName);
                    String mnemonic = this.compositionLookupProperties.getProperty(name + "." + "MnemonicKey", "").trim();
                    JMenu subMenu = this.doCreateMenu(name, this.getStructureOfActionNames(name, MENU_ACTIONS), context, null);
                    if (subMenu != null) {
                        subMenu.setName(name);
                        subMenu.setText(menuTitle);
                        if (mnemonic.length() > 0) {
                            subMenu.setMnemonic(mnemonic.charAt(0));
                        }
                        menuBar.add(subMenu);
                    }
                }
            }
            if (null == action) continue;
            menuBar.add(new IconJMenuItem(action, true));
        }
        return menuBar;
    }

    public void putLookupProperty(String key, String value) {
        this.compositionLookupProperties.put((Object)key, (Object)value);
    }

    public String getLookupProperty(String key) {
        return (String)this.compositionLookupProperties.get((Object)key);
    }
}

