/*
 * Decompiled with CFR 0.152.
 */
package com.levigo.util.swing.action;

import com.levigo.util.swing.SlickBevelBorder;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonModel;
import javax.swing.DefaultButtonModel;
import javax.swing.JToggleButton;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;

public class NonUglyActionJToggleButton
extends JToggleButton {
    public static final int WITHOUT_BORDER = 0;
    public static final int WITH_BORDER = 1;
    public static final int TOOLBAR_MAINOFFICE = 3;
    public static final int TOOLBAR_APPLICATION = 4;
    private static Font timesFont = new Font("Times-Roman", 0, 10);
    private static Border defaultButtonBorder = new SlickBevelBorder(SlickBevelBorder.AUTO_SELECT);
    private static RolloverListener rolloverListener = new RolloverListener();
    ActionPropertyChangeListener actionPropertyChangeListener = null;

    public NonUglyActionJToggleButton(Action action) {
        this(action, 4);
    }

    public NonUglyActionJToggleButton(Action action, int style) {
        this.setModel(new DefaultButtonModel());
        this.setAction(action);
        if (null != this.getIcon()) {
            this.setText("");
        }
        this.init(this.getText(), this.getIcon());
        this.initialize(style);
        this.disableFocusable();
    }

    private void disableFocusable() {
        if (System.getProperty("java.version").indexOf("1.4") >= 0) {
            try {
                Class[] paramClasses = new Class[1];
                Object[] param = new Object[1];
                paramClasses[0] = Boolean.TYPE;
                param[0] = Boolean.FALSE;
                Class<?> frameClass = this.getClass();
                Method m = frameClass.getMethod("setFocusable", paramClasses);
                m.invoke((Object)this, param);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void initialize(int style) {
        this.setFont(timesFont);
        this.setFocusPainted(false);
        if (style > 0) {
            this.setBorderPainted(true);
        } else {
            this.setBorderPainted(false);
        }
        this.setMargin(new Insets(-1, -1, -1, -1));
        this.setRolloverEnabled(true);
        Border border = defaultButtonBorder;
        if (style == 4) {
            border = new SlickBevelBorder(SlickBevelBorder.AUTO_ROLLOVER | SlickBevelBorder.AUTO_SELECT);
        }
        if (style == 3) {
            border = new EtchedBorder();
        }
        super.setBorder(border);
        this.addMouseListener(rolloverListener);
    }

    public void setBorder(Border border) {
    }

    public void setRolloverEnabled(boolean b) {
        super.setRolloverEnabled(true);
    }

    protected void configurePropertiesFromAction(Action a) {
        Object temp = a.getValue("checked");
        if (temp != null) {
            this.setSelected(temp.toString().equalsIgnoreCase("true"));
        }
        super.configurePropertiesFromAction(a);
        if (a.getValue("LongDescription") != null && !a.getValue("LongDescription").equals("")) {
            this.setToolTipText(a != null ? (String)a.getValue("LongDescription") : null);
        }
    }

    protected PropertyChangeListener createActionPropertyChangeListener(Action a) {
        if (this.actionPropertyChangeListener == null) {
            this.actionPropertyChangeListener = new ActionPropertyChangeListener();
        } else {
            a.removePropertyChangeListener(this.actionPropertyChangeListener);
        }
        a.addPropertyChangeListener(this.actionPropertyChangeListener);
        return super.createActionPropertyChangeListener(a);
    }

    public boolean isFocusTraversable() {
        return false;
    }

    private class ActionPropertyChangeListener
    implements PropertyChangeListener {
        private ActionPropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("checked")) {
                NonUglyActionJToggleButton.this.setSelected((Boolean)evt.getNewValue());
                NonUglyActionJToggleButton.this.repaint();
            }
        }
    }

    private static class RolloverListener
    extends MouseAdapter {
        private RolloverListener() {
        }

        public void mouseEntered(MouseEvent e) {
            AbstractButton b = (AbstractButton)e.getSource();
            ButtonModel model = b.getModel();
            if (b.isRolloverEnabled()) {
                model.setRollover(true);
            }
            if (model.isPressed()) {
                model.setArmed(true);
            }
        }

        public void mouseExited(MouseEvent e) {
            AbstractButton b = (AbstractButton)e.getSource();
            ButtonModel model = b.getModel();
            if (b.isRolloverEnabled()) {
                model.setRollover(false);
            }
            model.setArmed(false);
        }
    }
}

