/*
 * Decompiled with CFR 0.152.
 */
package com.levigo.util.swing.action;

import com.levigo.util.swing.JButtonGroup;
import com.levigo.util.swing.action.NonUglyActionJToggleButton;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JPopupMenu;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PopupJToggleButton
extends NonUglyActionJToggleButton {
    protected JPopupMenu popup = null;
    protected PopUpHandler popupHandler = null;

    public PopupJToggleButton(Action action) {
        super(action);
    }

    public PopupJToggleButton(Action action, JPopupMenu popupMenu) {
        this(action);
        this.setPopUpMenu(popupMenu);
    }

    public void setPopUpMenu(JPopupMenu aPopUpMenu) {
        Object btnGroupObject;
        if (this.popup == aPopUpMenu) {
            return;
        }
        if (this.popup != null && (btnGroupObject = this.popup.getClientProperty("ButtonGroup")) != null && btnGroupObject instanceof JButtonGroup) {
            ((JButtonGroup)btnGroupObject).removeChangeListener(this.popupHandler);
        }
        this.removeMouseListener(this.popupHandler);
        this.popup = aPopUpMenu;
        if (aPopUpMenu != null) {
            if (this.popupHandler == null) {
                this.popupHandler = new PopUpHandler();
            }
            this.addMouseListener(this.popupHandler);
            btnGroupObject = this.popup.getClientProperty("ButtonGroup");
            if (btnGroupObject != null && btnGroupObject instanceof JButtonGroup) {
                this.updateButton(((JButtonGroup)btnGroupObject).getSelected());
                ((JButtonGroup)btnGroupObject).addChangeListener(this.popupHandler);
            }
        }
    }

    protected void updateButton(AbstractButton selectedActionButton) {
        Action action;
        Icon icon = null;
        Action action2 = action = selectedActionButton == null ? this.getAction() : selectedActionButton.getAction();
        if (action != null) {
            icon = (Icon)action.getValue("SmallIcon");
        }
        if (icon != null) {
            this.setIcon(icon);
        }
        String tooltip = null;
        if (selectedActionButton == null) {
            tooltip = this.getToolTipText();
        }
        if (tooltip == null && action != null) {
            tooltip = (String)action.getValue("LongDescription");
        }
        this.setToolTipText(tooltip);
    }

    private class PopUpHandler
    extends MouseAdapter
    implements ChangeListener {
        private PopUpHandler() {
        }

        public void mouseClicked(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger() && !e.isConsumed() && PopupJToggleButton.this.popup != null) {
                PopupJToggleButton.this.popup.show((Component)e.getSource(), e.getX(), e.getY());
                e.consume();
            }
        }

        public void stateChanged(ChangeEvent e) {
            PopupJToggleButton.this.updateButton(((JButtonGroup)e.getSource()).getSelected());
        }
    }
}

