/*
 * Decompiled with CFR 0.152.
 */
package com.levigo.util.swing.action;

import com.levigo.util.swing.action.Context;
import com.levigo.util.swing.action.MenuComponentFactory;
import com.levigo.util.swing.action.NonUglyActionJToggleButton;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;

public class PopupMenuButton
extends NonUglyActionJToggleButton {
    private JLabel dummyLabel;

    public PopupMenuButton(final Context context, final MenuComponentFactory mcf, final String menuName) {
        super(new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                PopupMenuButton.showPopup(mcf, context, menuName, e);
            }
        });
        this.setContentAreaFilled(false);
        this.setLayout(new BoxLayout(this, 0));
        super.setIcon(null);
        if (null == this.dummyLabel) {
            this.dummyLabel = new JLabel();
        }
        this.add(this.dummyLabel);
        this.add(new JLabel(new Icon(){

            public void paintIcon(Component c, Graphics g, int x, int y) {
                g.setColor(c.getForeground());
                g.translate(x + 3, y);
                g.fillPolygon(new int[]{0, 5, 2, 0}, new int[]{0, 0, 3, 0}, 4);
            }

            public int getIconWidth() {
                return 11;
            }

            public int getIconHeight() {
                return 4;
            }
        }));
        this.setIcon(this.getIcon());
        this.setText(null);
    }

    public void setIcon(Icon defaultIcon) {
        if (null == this.dummyLabel) {
            this.dummyLabel = new JLabel();
        }
        this.dummyLabel.setIcon(defaultIcon);
    }

    protected void paintBorder(Graphics g) {
        super.paintBorder(g);
        if (this.getModel().isRollover()) {
            int h = this.getHeight();
            int x = this.dummyLabel.getWidth();
            g.setColor(this.getBackground().darker());
            g.drawLine(x, 0, x, h);
            g.setColor(this.getBackground().brighter());
            g.drawLine(x + 1, 0, x + 1, h - 2);
        }
    }

    protected static void showPopup(MenuComponentFactory mcf, Context context, String menuName, ActionEvent e) {
        JComponent c = (JComponent)e.getSource();
        JPopupMenu cm = mcf.getContextMenu(menuName, context);
        Dimension csize = c.getSize();
        Dimension msize = cm.getSize();
        int cy = c.getLocationOnScreen().y;
        int y = cy + csize.height + msize.height > Toolkit.getDefaultToolkit().getScreenSize().height ? Math.max(0, -csize.height + cy) - cy : csize.height;
        cm.show(c, 0, y);
    }
}

