/*
 * Decompiled with CFR 0.152.
 */
package com.levigo.util.swing.overflow;

import com.levigo.util.swing.overflow.OverflowJPopupMenu;
import java.awt.Component;
import javax.accessibility.AccessibleContext;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class OverflowJMenu
extends JMenu
implements PopupMenuListener {
    JPopupMenu myMenu = new OverflowJPopupMenu();

    public OverflowJMenu(String s) {
        super(s);
        this.getPopupMenu().setInvoker(this);
        this.popupListener = this.createWinListener(this.getPopupMenu());
        this.getPopupMenu().addPopupMenuListener(new PopupMenuListener(){

            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            public void popupMenuCanceled(PopupMenuEvent e) {
                OverflowJMenu.this.fireMenuCanceled();
                OverflowJMenu.this.getPopupMenu().setVisible(false);
            }
        });
    }

    public Component add(Component c) {
        AccessibleContext ac;
        if (c instanceof JComponent && (ac = ((JComponent)c).getAccessibleContext()) != null) {
            ac.setAccessibleParent(this);
        }
        this.getPopupMenu().add(c);
        return c;
    }

    public JMenuItem add(JMenuItem menuItem) {
        AccessibleContext ac = menuItem.getAccessibleContext();
        ac.setAccessibleParent(this);
        return this.getPopupMenu().add(menuItem);
    }

    public void addSeparator() {
        this.getPopupMenu().addSeparator();
    }

    public void insert(String s, int pos) {
        if (pos < 0) {
            throw new IllegalArgumentException("index less than zero.");
        }
        this.getPopupMenu().insert(new JMenuItem(s), pos);
    }

    public JMenuItem insert(JMenuItem mi, int pos) {
        if (pos < 0) {
            throw new IllegalArgumentException("index less than zero.");
        }
        AccessibleContext ac = mi.getAccessibleContext();
        ac.setAccessibleParent(this);
        this.getPopupMenu().insert(mi, pos);
        return mi;
    }

    public JMenuItem insert(Action a, int pos) {
        if (pos < 0) {
            throw new IllegalArgumentException("index less than zero.");
        }
        JMenuItem mi = new JMenuItem((String)a.getValue("Name"), (Icon)a.getValue("SmallIcon"));
        mi.setHorizontalTextPosition(11);
        mi.setVerticalTextPosition(0);
        mi.setEnabled(a.isEnabled());
        mi.setAction(a);
        this.getPopupMenu().insert(mi, pos);
        return mi;
    }

    public void insertSeparator(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("index less than zero.");
        }
        this.getPopupMenu().insert(new JPopupMenu.Separator(), index);
    }

    public JPopupMenu getPopupMenu() {
        return this.myMenu;
    }

    public void remove(JMenuItem item) {
        if (this.getPopupMenu() != null) {
            this.getPopupMenu().remove(item);
        }
    }

    public void remove(int pos) {
        if (pos < 0) {
            throw new IllegalArgumentException("index less than zero.");
        }
        if (pos > this.getPopupMenu().getComponentCount()) {
            throw new IllegalArgumentException("index greater than the number of items.");
        }
        if (this.getPopupMenu() != null) {
            this.getPopupMenu().remove(pos);
        }
    }

    public void remove(Component c) {
        if (this.getPopupMenu() != null) {
            this.getPopupMenu().remove(c);
        }
    }

    public void removeAll() {
        if (this.getPopupMenu() != null) {
            this.getPopupMenu().removeAll();
        }
    }

    public boolean isPopupMenuVisible() {
        return this.getPopupMenu().isVisible();
    }

    public void setMenuLocation(int x, int y) {
        if (this.getPopupMenu() != null) {
            this.getPopupMenu().setLocation(x, y);
        }
    }

    public void popupMenuCanceled(PopupMenuEvent e) {
        this.setVisible(false);
        if (this.getPopupMenu() != null) {
            this.getPopupMenu().setVisible(false);
        }
    }

    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        this.setVisible(false);
        if (this.getPopupMenu() != null) {
            this.getPopupMenu().setVisible(false);
        }
    }

    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
    }
}

