/*
 * Decompiled with CFR 0.152.
 */
package com.levigo.util.swing.table;

import com.levigo.util.swing.table.AppendableTableModel;
import com.levigo.util.swing.table.EditableRowHeaderTableModel;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;

public class EntryTableModel
extends AbstractTableModel
implements EditableRowHeaderTableModel {
    private AppendableTableModel master = null;
    private Vector fields = new Vector();
    private boolean isEdited = false;

    public EntryTableModel(AppendableTableModel masterTableModel) {
        this.master = masterTableModel;
    }

    public String getColumnName(int i) {
        return this.master.getColumnName(i);
    }

    public int getColumnCount() {
        return this.master.getColumnCount();
    }

    public int getRowCount() {
        return 1;
    }

    public Object getValueAt(int row, int col) {
        this.ensureCapacity(col);
        return this.fields.get(col);
    }

    private void ensureCapacity(int col) {
        if (col >= this.fields.size() || null == this.fields.get(col)) {
            try {
                while (col >= this.fields.size()) {
                    this.fields.addElement(null);
                }
                this.fields.setElementAt(this.master.getColumnClass(col).newInstance(), col);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setValueAt(Object value, int row, int col) {
        this.ensureCapacity(col);
        this.fields.setElementAt(value, col);
        this.isEdited = true;
        this.fireTableCellUpdated(row, col);
    }

    public boolean isCellEditable(int arg0, int arg1) {
        return true;
    }

    public void clear() {
        this.fields.removeAllElements();
        this.isEdited = false;
        this.fireTableRowsUpdated(0, 0);
    }

    public boolean appendRow() {
        if (!this.isEdited) {
            return false;
        }
        return this.master.appendRow(this.fields.toArray());
    }

    public boolean isEdited() {
        return this.isEdited;
    }

    public boolean isRowLocked(int row) {
        return false;
    }

    public boolean isEntryRow(int row) {
        return true;
    }
}

