/*
 * Decompiled with CFR 0.152.
 */
package com.levigo.util.swing.table;

import com.levigo.util.swing.table.SortableTableModel;
import java.awt.Component;
import javax.swing.JTable;

public class JTableFormatter {
    private static final int EXTRA_SPACE = 7;
    private static final int SORTHEADER_EXTRA_SPACE = 28;

    public static void initColumnSizes(JTable table) {
        for (int col = 0; col < table.getColumnModel().getColumnCount(); ++col) {
            int currentMaxWidth = JTableFormatter.calculateHeadingWidth(table, col);
            table.getColumnModel().getColumn(col).setPreferredWidth(currentMaxWidth + 7);
            table.getColumnModel().getColumn(col).setMinWidth(currentMaxWidth + 7);
            for (int row = 0; row < table.getRowCount(); ++row) {
                int cellWidth = JTableFormatter.calculateCellWidth(table, col, row);
                if (cellWidth <= currentMaxWidth) continue;
                table.getColumnModel().getColumn(col).setPreferredWidth(cellWidth + 7);
                currentMaxWidth = cellWidth;
            }
        }
    }

    private static int calculateHeadingWidth(JTable table, int col) {
        Component comp = table.getTableHeader().getDefaultRenderer().getTableCellRendererComponent(null, table.getTableHeader().getColumnModel().getColumn(col).getHeaderValue(), false, false, 0, col);
        int headingWidth = comp.getPreferredSize().width;
        if (table.getModel() instanceof SortableTableModel) {
            headingWidth += 28;
        }
        return headingWidth;
    }

    private static int calculateCellWidth(JTable table, int col, int row) {
        Component comp = table.getDefaultRenderer(table.getModel().getColumnClass(col)).getTableCellRendererComponent(table, table.getValueAt(row, col), false, false, 0, col);
        return comp.getPreferredSize().width;
    }

    public static void setColumnSizeToMaxCellWidth(JTable table, int col) {
        int currentMaxWidth = JTableFormatter.calculateHeadingWidth(table, col);
        table.getColumnModel().getColumn(col).setMinWidth(currentMaxWidth + 7);
        for (int row = 0; row < table.getRowCount(); ++row) {
            int cellWidth = JTableFormatter.calculateCellWidth(table, col, row);
            if (cellWidth <= currentMaxWidth) continue;
            table.getColumnModel().getColumn(col).setMinWidth(cellWidth + 7);
            currentMaxWidth = cellWidth;
        }
    }
}

