/*
 * Decompiled with CFR 0.152.
 */
package com.levigo.util.swing.table;

import com.levigo.util.swing.table.TableRowHeaderUI;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.ObjectOutputStream;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.plaf.TableHeaderUI;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class JTableRowHeader
extends JComponent {
    protected boolean resizingAllowed;
    private static final String uiClassID = "TableRowHeaderUI";
    protected JTable table;
    private TableCellRenderer defaultRenderer;

    public JTableRowHeader() {
        this.initializeLocalVars();
        this.updateUI();
    }

    public void setTable(JTable table) {
        JTable old = this.table;
        this.table = table;
        this.firePropertyChange("table", old, table);
        TableSelectionListener tsl = new TableSelectionListener();
        table.getSelectionModel().addListSelectionListener(tsl);
        table.getColumnModel().addColumnModelListener(tsl);
        table.getModel().addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent e) {
                if (e.getType() != 0) {
                    JTableRowHeader.this.resizeAndRepaint();
                }
            }
        });
    }

    public TableModel getTableModel() {
        return this.table.getModel();
    }

    public void setResizingAllowed(boolean resizingAllowed) {
        boolean old = this.resizingAllowed;
        this.resizingAllowed = resizingAllowed;
        this.firePropertyChange("resizingAllowed", old, resizingAllowed);
    }

    public void setDefaultRenderer(TableCellRenderer defaultRenderer) {
        this.defaultRenderer = defaultRenderer;
    }

    public TableCellRenderer getDefaultRenderer() {
        return this.defaultRenderer;
    }

    public int getCellHeight() {
        return this.table.getRowHeight();
    }

    public int rowAtPoint(Point point) {
        return point.y / this.getCellHeight();
    }

    public Rectangle getHeaderRect(int row) {
        Rectangle r = new Rectangle();
        r.width = this.getWidth();
        if (row >= 0) {
            if (row >= this.table.getModel().getRowCount()) {
                r.y = this.getHeight();
            } else {
                r.height = this.getCellHeight();
                r.y = r.height * row;
            }
        }
        return r;
    }

    public String getToolTipText(MouseEvent event) {
        return "";
    }

    public TableHeaderUI getUI() {
        return (TableHeaderUI)this.ui;
    }

    public void setUI(TableHeaderUI ui) {
        if (this.ui != ui) {
            super.setUI(ui);
            this.repaint();
        }
    }

    public void updateUI() {
        this.setUI(new TableRowHeaderUI());
        this.resizeAndRepaint();
        this.invalidate();
    }

    public String getUIClassID() {
        return uiClassID;
    }

    protected TableCellRenderer createDefaultRenderer() {
        DefaultTableCellRenderer label = new DefaultTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                this.setText(value == null ? Integer.toString(row) : value.toString());
                this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
                JTableHeader header = table.getTableHeader();
                if (null != header) {
                    this.setForeground(header.getForeground());
                    this.setBackground(header.getBackground());
                    this.setFont(header.getFont());
                }
                return this;
            }
        };
        label.setHorizontalAlignment(0);
        return label;
    }

    protected void initializeLocalVars() {
        this.setOpaque(true);
        this.table = null;
        ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
        toolTipManager.registerComponent(this);
        this.setDefaultRenderer(this.createDefaultRenderer());
    }

    public void resizeAndRepaint() {
        this.revalidate();
        this.repaint();
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        if (this.ui != null && this.getUIClassID().equals(uiClassID)) {
            this.ui.installUI(this);
        }
    }

    protected String paramString() {
        String resizingAllowedString = this.resizingAllowed ? "true" : "false";
        return super.paramString() + ",resizingAllowed=" + resizingAllowedString;
    }

    public JTable getTable() {
        return this.table;
    }

    public boolean getResizingAllowed() {
        return this.resizingAllowed;
    }

    private class TableSelectionListener
    implements ListSelectionListener,
    TableColumnModelListener {
        private TableSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                JTableRowHeader.this.repaint();
            }
        }

        public void columnAdded(TableColumnModelEvent e) {
            JTableRowHeader.this.repaint();
        }

        public void columnMarginChanged(ChangeEvent e) {
        }

        public void columnMoved(TableColumnModelEvent e) {
        }

        public void columnRemoved(TableColumnModelEvent e) {
            JTableRowHeader.this.repaint();
        }

        public void columnSelectionChanged(ListSelectionEvent e) {
            JTableRowHeader.this.repaint();
        }
    }
}

