/*
 * Decompiled with CFR 0.152.
 */
package com.levigo.util.swing.table;

import com.levigo.util.swing.table.SortButtonRenderer;
import com.levigo.util.swing.table.SortableTableModel;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class SortableJTable
extends JTable {
    private SortButtonRenderer renderer;

    public void setTableHeader(JTableHeader tableHeader) {
        super.setTableHeader(tableHeader);
        tableHeader.addMouseListener(new HeaderListener(tableHeader));
    }

    public void addColumn(TableColumn aColumn) {
        super.addColumn(aColumn);
        if (((SortableTableModel)this.getModel()).isColumnSortable(aColumn)) {
            aColumn.setHeaderRenderer(this.getHeaderRenderer(aColumn));
        }
    }

    public void setModel(SortableTableModel dataModel) {
        super.setModel(dataModel);
    }

    protected TableCellRenderer getHeaderRenderer(TableColumn column) {
        if (null == this.renderer) {
            this.renderer = new SortButtonRenderer();
        }
        return this.renderer;
    }

    public SortableJTable() {
    }

    public SortableJTable(SortableTableModel dm) {
        super(dm);
    }

    public SortableJTable(SortableTableModel dm, TableColumnModel cm) {
        super(dm, cm);
    }

    public SortableJTable(SortableTableModel dm, TableColumnModel cm, ListSelectionModel sm) {
        super(dm, cm, sm);
    }

    public void columnMoved(TableColumnModelEvent e) {
        int cc = this.getColumnCount();
        for (int i = 0; i < cc; ++i) {
            TableCellRenderer hr = this.getColumnModel().getColumn(i).getHeaderRenderer();
            if (!(hr instanceof SortButtonRenderer)) continue;
            ((SortButtonRenderer)hr).setPressedColumn(-1);
        }
        super.columnMoved(e);
    }

    private class HeaderListener
    extends MouseAdapter {
        private JTableHeader header;

        public HeaderListener(JTableHeader header) {
            this.header = header;
        }

        public void mousePressed(MouseEvent e) {
            if ((e.getModifiers() & 0x10) == 0) {
                return;
            }
            int viewColumnIndex = this.header.columnAtPoint(e.getPoint());
            if (viewColumnIndex >= 0 && viewColumnIndex < SortableJTable.this.getColumnCount()) {
                TableColumn tableColumn = SortableJTable.this.getColumnModel().getColumn(viewColumnIndex);
                if (null != tableColumn && tableColumn.getHeaderRenderer() instanceof SortButtonRenderer) {
                    ((SortButtonRenderer)tableColumn.getHeaderRenderer()).setPressedColumn(viewColumnIndex);
                }
                this.header.repaint();
            }
        }

        public void mouseReleased(MouseEvent e) {
            if ((e.getModifiers() & 0x10) == 0) {
                return;
            }
            int viewColumnIndex = this.header.columnAtPoint(e.getPoint());
            if (viewColumnIndex >= 0 && viewColumnIndex < SortableJTable.this.getColumnCount()) {
                TableColumn tableColumn = SortableJTable.this.getColumnModel().getColumn(viewColumnIndex);
                if (null != tableColumn && tableColumn.getHeaderRenderer() instanceof SortButtonRenderer) {
                    ((SortButtonRenderer)tableColumn.getHeaderRenderer()).setPressedColumn(-1);
                }
                this.header.repaint();
            }
        }

        public void mouseClicked(MouseEvent e) {
            TableColumn tableColumn;
            if ((e.getModifiers() & 0x10) == 0) {
                return;
            }
            int viewColumnIndex = SortableJTable.this.columnAtPoint(e.getPoint());
            if (viewColumnIndex < 0 || viewColumnIndex >= SortableJTable.this.getColumnCount()) {
                return;
            }
            int col = SortableJTable.this.convertColumnIndexToModel(viewColumnIndex);
            SortableTableModel model = (SortableTableModel)this.header.getTable().getModel();
            if (!model.isColumnSortable(SortableJTable.this.getColumnModel().getColumn(viewColumnIndex))) {
                return;
            }
            if (this.header.getTable().isEditing()) {
                this.header.getTable().getCellEditor().stopCellEditing();
            }
            if (null != (tableColumn = SortableJTable.this.getColumnModel().getColumn(viewColumnIndex)) && tableColumn.getHeaderRenderer() instanceof SortButtonRenderer) {
                ((SortButtonRenderer)tableColumn.getHeaderRenderer()).setPressedColumn(-1);
            }
            if (e.isShiftDown()) {
                int columns = model.getColumnCount();
                int[][] directions = new int[columns][2];
                for (int i = 0; i < columns; ++i) {
                    int prio = model.getSortPriority(i);
                    if (prio < 0 || prio >= columns) continue;
                    directions[prio][0] = model.getSortDirection(i);
                    directions[prio][1] = i;
                    if (i != col || directions[prio][0] == 0) continue;
                    int[] nArray = directions[prio];
                    nArray[0] = nArray[0] * -1;
                }
                int maxCriteria = 5;
                for (int i = 0; i < columns && i < maxCriteria && directions[i][0] != 0; ++i) {
                    model.addCriterium(directions[i][1], directions[i][0] > 0, i == 0);
                }
                if (model.getSortDirection(col) == 0) {
                    model.addCriterium(col, true, directions[0][0] == 0);
                }
            } else {
                boolean newSortDirection = model.getSortDirection(col) <= 0;
                model.addCriterium(col, newSortDirection, true);
            }
            model.resort();
            this.header.repaint();
        }
    }
}

