/*
 * Decompiled with CFR 0.152.
 */
package com.levigo.util.swing.table;

import com.levigo.util.swing.table.SortableTableModel;
import java.util.Iterator;
import java.util.Vector;

public class TableSorter {
    private SortableTableModel model;
    private Vector sortCriteria = new Vector();

    public TableSorter(SortableTableModel model) {
        this.model = model;
    }

    public void addCriterium(int columnIndex, boolean isAscent, boolean clearExisting) {
        if (clearExisting) {
            this.sortCriteria.clear();
        }
        for (int i = 0; i < this.sortCriteria.size(); ++i) {
            if (((SortCriterium)this.sortCriteria.get(i)).getColumnIndex() != columnIndex) continue;
            this.sortCriteria.remove(i);
        }
        this.sortCriteria.add(new SortCriterium(columnIndex, isAscent));
    }

    public int getSortPriority(int column) {
        int priority = 0;
        Iterator i = this.sortCriteria.iterator();
        while (i.hasNext()) {
            SortCriterium sc = (SortCriterium)i.next();
            if (sc.columnIndex == column) {
                return priority;
            }
            ++priority;
        }
        return -1;
    }

    public int getSortDirection(int column) {
        Iterator i = this.sortCriteria.iterator();
        while (i.hasNext()) {
            SortCriterium sc = (SortCriterium)i.next();
            if (sc.columnIndex != column) continue;
            return sc.isAscent ? 1 : -1;
        }
        return 0;
    }

    private void sortQuick(int left, int right) {
        if (right - left <= 0) {
            return;
        }
        int pivot = right;
        int leftPtr = left - 1;
        int rightPtr = right;
        while (true) {
            if (this.compareRows(++leftPtr, pivot) < 0) {
                continue;
            }
            while (rightPtr > 0 && this.compareRows(--rightPtr, pivot) > 0) {
            }
            if (leftPtr >= rightPtr) break;
            this.model.swapRows(leftPtr, rightPtr);
        }
        this.model.swapRows(leftPtr, right);
        int partition = leftPtr;
        this.sortQuick(left, partition - 1);
        this.sortQuick(partition + 1, right);
    }

    private int compareRows(int row1, int row2) {
        int result = 0;
        for (int i = 0; i < this.sortCriteria.size() && result == 0; ++i) {
            SortCriterium currentCriteria = (SortCriterium)this.sortCriteria.get(i);
            boolean isAscent = currentCriteria.isAscent();
            int columnIndex = currentCriteria.getColumnIndex();
            Comparable obj1 = this.model.getComparableAt(row1, columnIndex);
            Comparable obj2 = this.model.getComparableAt(row2, columnIndex);
            if (obj1 == null && obj2 == null) {
                result = 0;
            } else if (obj1 == null) {
                result = -1;
            } else if (obj2 == null) {
                result = 1;
            } else {
                try {
                    result = obj1.compareTo(obj2);
                }
                catch (ClassCastException cce) {
                    result = obj1.toString().compareTo(obj2.toString());
                }
            }
            if (isAscent) continue;
            result = -result;
        }
        return result;
    }

    public void resort() {
        this.sortQuick(0, this.model.getRowCount() - 1);
    }

    public int getInsertionIndex(Comparable[] columnValues) {
        int appropriateRowIndex;
        for (appropriateRowIndex = 0; appropriateRowIndex < this.model.getRowCount(); ++appropriateRowIndex) {
            int result = 0;
            if ((result = this.compareRowToComparables(columnValues, appropriateRowIndex, result)) > 0) break;
        }
        return appropriateRowIndex;
    }

    private int compareRowToComparables(Comparable[] columnValues, int row, int result) {
        for (int i = 0; i < this.sortCriteria.size() && result == 0; ++i) {
            SortCriterium currentCriteria = (SortCriterium)this.sortCriteria.get(i);
            boolean isAscent = currentCriteria.isAscent();
            int columnIndex = currentCriteria.getColumnIndex();
            Comparable obj1 = this.model.getComparableAt(row, columnIndex);
            Comparable obj2 = columnValues[columnIndex];
            result = obj1 == null && obj2 == null ? 0 : (obj1 == null ? -1 : (obj2 == null ? 1 : obj1.compareTo(obj2)));
            if (isAscent) continue;
            result = -result;
        }
        return result;
    }

    private class SortCriterium {
        private boolean isAscent = false;
        private int columnIndex = -1;

        SortCriterium(int columnIndex, boolean isAscent) {
            this.isAscent = isAscent;
            this.columnIndex = columnIndex;
        }

        protected boolean isAscent() {
            return this.isAscent;
        }

        protected int getColumnIndex() {
            return this.columnIndex;
        }
    }
}

