/*
 * Decompiled with CFR 0.152.
 */
package com.levigo.util.swing.text;

import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class NColumnsDigitDocument
extends PlainDocument {
    private int numberOfColumns = -1;

    public NColumnsDigitDocument(int cols) {
        this.numberOfColumns = Math.max(0, cols);
    }

    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        String currentText = this.getText(0, this.getLength());
        String beforeOffset = currentText.substring(0, offs);
        String afterOffset = currentText.substring(offs, currentText.length());
        String proposedResult = beforeOffset + str + afterOffset;
        if (this.numberOfColumns >= 0) {
            if (str != null) {
                if (proposedResult.length() <= this.numberOfColumns) {
                    if (this.isValid(proposedResult)) {
                        super.insertString(offs, str, a);
                    }
                } else if (this.isValid(proposedResult = proposedResult.substring(0, this.numberOfColumns))) {
                    super.remove(0, this.getLength());
                    super.insertString(0, proposedResult, a);
                }
            }
        } else if (this.isValid(proposedResult)) {
            super.insertString(offs, str, a);
        }
    }

    private boolean isValid(String proposedResult) {
        if (proposedResult == null || proposedResult.length() == 0) {
            return true;
        }
        for (int i = 0; i < proposedResult.length(); ++i) {
            if (Character.isDigit(proposedResult.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public int getNumberOfColumns() {
        return this.numberOfColumns;
    }

    public void setNumberOfColumns(int numberOfColumns) {
        this.numberOfColumns = numberOfColumns;
    }
}

