/*
 * Decompiled with CFR 0.152.
 */
package com.levigo.util.swing.text;

import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class NColumnsTextDocument
extends PlainDocument {
    private int numberOfColumns = -1;

    public NColumnsTextDocument() {
    }

    public NColumnsTextDocument(int cols) {
        this.numberOfColumns = cols;
    }

    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        if (this.numberOfColumns >= 0) {
            String currentText = this.getText(0, this.getLength());
            String beforeOffset = currentText.substring(0, offs);
            String afterOffset = currentText.substring(offs, currentText.length());
            String proposedResult = beforeOffset + str + afterOffset;
            if (str != null) {
                if (proposedResult.length() <= this.numberOfColumns) {
                    super.insertString(offs, str, a);
                } else {
                    proposedResult = proposedResult.substring(0, this.numberOfColumns);
                    super.remove(0, this.getLength());
                    super.insertString(0, proposedResult, a);
                }
            }
        } else {
            super.insertString(offs, str, a);
        }
    }

    public int getNumberOfColumns() {
        return this.numberOfColumns;
    }

    public void setNumberOfColumns(int numberOfColumns) {
        this.numberOfColumns = numberOfColumns;
    }
}

