import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

import sun.misc.BASE64Encoder;

import com.levigo.util.datatype.Base64;
import com.levigo.util.messaging.Message;
import com.levigo.util.messaging.MessageEvent;
import com.levigo.util.messaging.dialog.DefaultMessageDialog;

/**
 * @author B022444
 * 
 * 
 */
public class ConfigurationValueCrypter extends JPanel {
	public enum Algorithm {
		MD5, SHA1
	}

	public enum Mode {
		ENCRYPT_CBC, HASH;
	}

	public enum Encoding {
		Base64_BROKEN, Base64, Hex
	}

	MessageDigest seed;
	byte seedBytes[];
	JTextField value;
	JTextField result;
	private JComboBox modeBox;
	private JComboBox encodingBox;
	private JCheckBox useSeed;
	private JComboBox algorithmBox;

	/**
	 * Constructor for ConfigurationValueCrypter.
	 */
	public ConfigurationValueCrypter() {
		super();
		try {
			seed = MessageDigest.getInstance("SHA1");
			// initial seed with time
			seed.update(Long.toString(System.currentTimeMillis()).getBytes());
			seedBytes = seed.digest();

			initGUI();
		} catch (NoSuchAlgorithmException e) {
			new DefaultMessageDialog(null, "Klappt nicht.", new MessageEvent(null,
					new Message("foo", Message.DISPLAY, Message.ERROR,
							"Kann nicht verschlsseln", "Fehler beim Erstellen des Digests",
							null, e, null)));
		}
	}

	private void initGUI() {
		setLayout(new GridBagLayout());

		GridBagConstraints gbc = new GridBagConstraints();
		gbc.gridx = gbc.gridy = 0;
		gbc.fill = GridBagConstraints.NONE;
		gbc.anchor = GridBagConstraints.WEST;
		gbc.insets.bottom = 5;
		gbc.insets.right = 5;
		gbc.weightx = 0;

		// mode -----------------------------
		gbc.gridy++;
		gbc.gridx = 0;
		add(new JLabel("Modus:"), gbc);

		modeBox = new JComboBox(new DefaultComboBoxModel(Mode.values()));
		ActionListener updateListener = new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				update();
			}
		};
		modeBox.addActionListener(updateListener);
		gbc.gridx = 1;
		add(modeBox, gbc);

		// algorithm -----------------------------
		gbc.gridy++;
		gbc.gridx = 0;
		add(new JLabel("Algorithmus:"), gbc);

		algorithmBox = new JComboBox(new DefaultComboBoxModel(Algorithm.values()));
		algorithmBox.addActionListener(updateListener);
		gbc.gridx = 1;
		add(algorithmBox, gbc);

		// kodierung -----------------------------
		gbc.gridy++;
		gbc.gridx = 0;
		gbc.weightx = 0;

		add(new JLabel("Kodierung:"), gbc);

		encodingBox = new JComboBox(new DefaultComboBoxModel(Encoding.values()));
		encodingBox.addActionListener(updateListener);
		gbc.gridx = 1;
		gbc.weightx = 1;
		add(encodingBox, gbc);

		// seed -----------------------------
		gbc.gridy++;
		gbc.gridx = 0;
		gbc.weightx = 0;

		add(new JLabel("Seed verwenden:"), gbc);

		useSeed = new JCheckBox();
		useSeed.setSelected(true);
		useSeed.addActionListener(updateListener);
		gbc.gridx = 1;
		gbc.weightx = 1;
		add(useSeed, gbc);

		// value -----------------------------
		gbc.fill = GridBagConstraints.BOTH;
		gbc.gridy++;
		gbc.gridx = 0;
		gbc.weightx = 0;

		add(new JLabel("Konfigurationswert/Passwort:"), gbc);

		value = new JTextField(50);
		gbc.gridx = 1;
		gbc.weightx = 1;
		add(value, gbc);

		// result -----------------------------
		gbc.gridy++;
		gbc.gridx = 0;
		gbc.weightx = 0;
		add(new JLabel("Verschlsselt:"), gbc);

		result = new JTextField(50);
		result.setEditable(false);
		gbc.gridx = 1;
		gbc.weightx = 1;
		add(result, gbc);

		value.getDocument().addDocumentListener(new DocumentListener() {
			/**
			 * @see javax.swing.event.DocumentListener#insertUpdate(DocumentEvent)
			 */
			public void insertUpdate(DocumentEvent e) {
				update();
			}

			/**
			 * @see javax.swing.event.DocumentListener#removeUpdate(DocumentEvent)
			 */
			public void removeUpdate(DocumentEvent e) {
				update();
			}

			/**
			 * @see javax.swing.event.DocumentListener#changedUpdate(DocumentEvent)
			 */
			public void changedUpdate(DocumentEvent e) {
				update();
			}
		});

		// add a mouse listener to update the seed
		addMouseMotionListener(new MouseMotionAdapter() {
			/**
			 * @see java.awt.event.MouseMotionListener#mouseMoved(MouseEvent)
			 */
			@Override
			public void mouseMoved(MouseEvent e) {
				updateSeed(e.getPoint().toString().getBytes());
			}
		});
	}

	public static String encrypt(byte seedBytes[], String value, Mode mode, Algorithm algorithm,
			Encoding encoding, boolean useSeed) {
		byte valueBytes[] = value.getBytes();

		try {
			MessageDigest md = MessageDigest.getInstance(algorithm.toString());
			if (useSeed) {
				md.update("DWxdHEH7mn1cn0shL+E8d7H".getBytes()); // secret
				md.update(seedBytes, 0, 8);
			}

			switch (mode){
				case ENCRYPT_CBC :
					// encrypt string
					int encryptOffset = 0;
					while (encryptOffset < valueBytes.length) {
						// produce cipher block
						byte cipherBlock[] = md.digest();
						int i = cipherBlock.length;

						// encrypt
						while (i-- > 0 && encryptOffset < valueBytes.length)
							valueBytes[encryptOffset++] ^= cipherBlock[i];

						// if we need another cipher block, update the digest with
						// the previous cipher block
						if (encryptOffset < valueBytes.length)
							md.update(cipherBlock);
					}
					break;

				case HASH :
					md.update(valueBytes);
					valueBytes = md.digest();
			}

			byte resultBytes[] = valueBytes;

			if (useSeed) {
				resultBytes = new byte[seedBytes.length + valueBytes.length];
				System.arraycopy(seedBytes, 0, resultBytes, 0, seedBytes.length);
				System.arraycopy(valueBytes, 0, resultBytes, seedBytes.length,
						valueBytes.length);
			}

			switch (encoding){
				case Base64 :
					return "{" + algorithm + "|Base64}"
							+ new BASE64Encoder().encode(resultBytes);

				case Hex :
					return "{" + algorithm + "|BigInteger}"
							+ new BigInteger(resultBytes).toString(16);

				case Base64_BROKEN :
				default :
					return "crypt:" + Base64.byteArrayToBase64(resultBytes);
			}
		} catch (NoSuchAlgorithmException e) {
			e.printStackTrace();
			System.exit(-1);
			return "";
		}
	}

	void updateSeed(byte bytes[]) {
		seed.update(seedBytes);
		seed.update(bytes);
		seedBytes = seed.digest();

		update();
	}

	void update() {
		String encrypted = encrypt(seedBytes, value.getText(), (Mode) modeBox
				.getSelectedItem(), (Algorithm) algorithmBox.getSelectedItem(),
				(Encoding) encodingBox.getSelectedItem(), useSeed.isSelected());
		result.setText(encrypted);
		result.requestFocus();
		result.setSelectionStart(0);
		result.setSelectionEnd(encrypted.length());
		result.copy();
		value.requestFocus();
	}

	public static void main(String[] args) {
		JFrame myFrame = new JFrame("Config Value Encrypter");
		myFrame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

		myFrame.setContentPane(new ConfigurationValueCrypter());

		myFrame.pack();
		myFrame.setVisible(true);
	}
}
