/*
 * Decompiled with CFR 0.152.
 */
package com.levigo.util.tools;

import com.levigo.util.datatype.Base64;
import com.levigo.util.messaging.Message;
import com.levigo.util.messaging.MessageEvent;
import com.levigo.util.messaging.dialog.DefaultMessageDialog;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.sf.retrotranslator.runtime.java.lang.Enum_;
import sun.misc.BASE64Encoder;

public class ConfigurationValueCrypter
extends JPanel {
    MessageDigest seed;
    byte[] seedBytes;
    JTextField value;
    JTextField result;
    private JComboBox modeBox;
    private JComboBox encodingBox;
    private JCheckBox useSeed;
    private JComboBox algorithmBox;

    public ConfigurationValueCrypter() {
        try {
            this.seed = MessageDigest.getInstance("SHA1");
            this.seed.update(Long.toString(System.currentTimeMillis()).getBytes());
            this.seedBytes = this.seed.digest();
            this.initGUI();
        }
        catch (NoSuchAlgorithmException e) {
            new DefaultMessageDialog(null, "Klappt nicht.", new MessageEvent(null, new Message("foo", "DISPLAY", "ERROR", "Kann nicht verschl\u00fcsseln", "Fehler beim Erstellen des Digests", null, (Throwable)e, null)));
        }
    }

    private void initGUI() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.fill = 0;
        gbc.anchor = 17;
        gbc.insets.bottom = 5;
        gbc.insets.right = 5;
        gbc.weightx = 0.0;
        ++gbc.gridy;
        gbc.gridx = 0;
        this.add((Component)new JLabel("Modus:"), gbc);
        this.modeBox = new JComboBox<Mode>(new DefaultComboBoxModel<Mode>(Mode.values()));
        ActionListener updateListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ConfigurationValueCrypter.this.update();
            }
        };
        this.modeBox.addActionListener(updateListener);
        gbc.gridx = 1;
        this.add((Component)this.modeBox, gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        this.add((Component)new JLabel("Algorithmus:"), gbc);
        this.algorithmBox = new JComboBox<Algorithm>(new DefaultComboBoxModel<Algorithm>(Algorithm.values()));
        this.algorithmBox.addActionListener(updateListener);
        gbc.gridx = 1;
        this.add((Component)this.algorithmBox, gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.weightx = 0.0;
        this.add((Component)new JLabel("Kodierung:"), gbc);
        this.encodingBox = new JComboBox<Encoding>(new DefaultComboBoxModel<Encoding>(Encoding.values()));
        this.encodingBox.addActionListener(updateListener);
        gbc.gridx = 1;
        gbc.weightx = 1.0;
        this.add((Component)this.encodingBox, gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.weightx = 0.0;
        this.add((Component)new JLabel("Seed verwenden:"), gbc);
        this.useSeed = new JCheckBox();
        this.useSeed.setSelected(true);
        this.useSeed.addActionListener(updateListener);
        gbc.gridx = 1;
        gbc.weightx = 1.0;
        this.add((Component)this.useSeed, gbc);
        gbc.fill = 1;
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.weightx = 0.0;
        this.add((Component)new JLabel("Konfigurationswert/Passwort:"), gbc);
        this.value = new JTextField(50);
        gbc.gridx = 1;
        gbc.weightx = 1.0;
        this.add((Component)this.value, gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.weightx = 0.0;
        this.add((Component)new JLabel("Verschl\u00fcsselt:"), gbc);
        this.result = new JTextField(50);
        this.result.setEditable(false);
        gbc.gridx = 1;
        gbc.weightx = 1.0;
        this.add((Component)this.result, gbc);
        this.value.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                ConfigurationValueCrypter.this.update();
            }

            public void removeUpdate(DocumentEvent e) {
                ConfigurationValueCrypter.this.update();
            }

            public void changedUpdate(DocumentEvent e) {
                ConfigurationValueCrypter.this.update();
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent e) {
                ConfigurationValueCrypter.this.updateSeed(e.getPoint().toString().getBytes());
            }
        });
    }

    public static String encrypt(byte[] seedBytes, String value, Mode mode, Algorithm algorithm, Encoding encoding, boolean useSeed) {
        byte[] valueBytes = value.getBytes();
        try {
            MessageDigest md = MessageDigest.getInstance(algorithm.toString());
            if (useSeed) {
                md.update("DWxdHEH7mn1cn0shL+E8d7H".getBytes());
                md.update(seedBytes, 0, 8);
            }
            switch (4.$SwitchMap$com$levigo$util$tools$ConfigurationValueCrypter$Mode[mode.ordinal()]) {
                case 1: {
                    int encryptOffset = 0;
                    while (encryptOffset < valueBytes.length) {
                        byte[] cipherBlock = md.digest();
                        int i = cipherBlock.length;
                        while (i-- > 0 && encryptOffset < valueBytes.length) {
                            int n = encryptOffset++;
                            valueBytes[n] = (byte)(valueBytes[n] ^ cipherBlock[i]);
                        }
                        if (encryptOffset >= valueBytes.length) continue;
                        md.update(cipherBlock);
                    }
                    break;
                }
                case 2: {
                    md.update(valueBytes);
                    valueBytes = md.digest();
                }
            }
            byte[] resultBytes = valueBytes;
            if (useSeed) {
                resultBytes = new byte[seedBytes.length + valueBytes.length];
                System.arraycopy(seedBytes, 0, resultBytes, 0, seedBytes.length);
                System.arraycopy(valueBytes, 0, resultBytes, seedBytes.length, valueBytes.length);
            }
            switch (4.$SwitchMap$com$levigo$util$tools$ConfigurationValueCrypter$Encoding[encoding.ordinal()]) {
                case 1: {
                    return "{" + (Object)((Object)algorithm) + "|Base64}" + new BASE64Encoder().encode(resultBytes);
                }
                case 2: {
                    return "{" + (Object)((Object)algorithm) + "|BigInteger}" + new BigInteger(resultBytes).toString(16);
                }
            }
            return "crypt:" + Base64.byteArrayToBase64((byte[])resultBytes);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            System.exit(-1);
            return "";
        }
    }

    void updateSeed(byte[] bytes) {
        this.seed.update(this.seedBytes);
        this.seed.update(bytes);
        this.seedBytes = this.seed.digest();
        this.update();
    }

    void update() {
        String encrypted = ConfigurationValueCrypter.encrypt(this.seedBytes, this.value.getText(), (Mode)((Object)this.modeBox.getSelectedItem()), (Algorithm)((Object)this.algorithmBox.getSelectedItem()), (Encoding)((Object)this.encodingBox.getSelectedItem()), this.useSeed.isSelected());
        this.result.setText(encrypted);
        this.result.requestFocus();
        this.result.setSelectionStart(0);
        this.result.setSelectionEnd(encrypted.length());
        this.result.copy();
        this.value.requestFocus();
    }

    public static void main(String[] args) {
        JFrame myFrame = new JFrame("Config Value Encrypter");
        myFrame.setDefaultCloseOperation(3);
        myFrame.setContentPane(new ConfigurationValueCrypter());
        myFrame.pack();
        myFrame.setVisible(true);
    }

    static class 4 {
        static final /* synthetic */ int[] $SwitchMap$com$levigo$util$tools$ConfigurationValueCrypter$Mode;
        static final /* synthetic */ int[] $SwitchMap$com$levigo$util$tools$ConfigurationValueCrypter$Encoding;

        static {
            $SwitchMap$com$levigo$util$tools$ConfigurationValueCrypter$Encoding = new int[Encoding.values().length];
            try {
                4.$SwitchMap$com$levigo$util$tools$ConfigurationValueCrypter$Encoding[Encoding.Base64.ordinal()] = 1;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                4.$SwitchMap$com$levigo$util$tools$ConfigurationValueCrypter$Encoding[Encoding.Hex.ordinal()] = 2;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                4.$SwitchMap$com$levigo$util$tools$ConfigurationValueCrypter$Encoding[Encoding.Base64_BROKEN.ordinal()] = 3;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            $SwitchMap$com$levigo$util$tools$ConfigurationValueCrypter$Mode = new int[Mode.values().length];
            try {
                4.$SwitchMap$com$levigo$util$tools$ConfigurationValueCrypter$Mode[Mode.ENCRYPT_CBC.ordinal()] = 1;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                4.$SwitchMap$com$levigo$util$tools$ConfigurationValueCrypter$Mode[Mode.HASH.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Encoding
    extends Enum_<Encoding> {
        public static final Encoding Base64_BROKEN = new Encoding("Base64_BROKEN", 0);
        public static final Encoding Base64 = new Encoding("Base64", 1);
        public static final Encoding Hex = new Encoding("Hex", 2);
        private static final /* synthetic */ Encoding[] $VALUES;
        static /* synthetic */ Class class$com$levigo$util$tools$ConfigurationValueCrypter$Encoding;

        public static Encoding[] values() {
            return (Encoding[])$VALUES.clone();
        }

        public static Encoding valueOf(String name) {
            Class<?> clazz = class$com$levigo$util$tools$ConfigurationValueCrypter$Encoding;
            if (clazz == null) {
                clazz = class$com$levigo$util$tools$ConfigurationValueCrypter$Encoding = new Encoding[0].getClass().getComponentType();
            }
            return (Encoding)Enum_.valueOf((Class)clazz, (String)name);
        }

        private Encoding() {
            super((String)var1_1, n);
        }

        static {
            $VALUES = new Encoding[]{Base64_BROKEN, Base64, Hex};
            Class<?> clazz = class$com$levigo$util$tools$ConfigurationValueCrypter$Encoding;
            if (clazz == null) {
                clazz = class$com$levigo$util$tools$ConfigurationValueCrypter$Encoding = new Encoding[0].getClass().getComponentType();
            }
            Enum_.setEnumConstants((Class)clazz, (Enum_[])Encoding.values());
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Mode
    extends Enum_<Mode> {
        public static final Mode ENCRYPT_CBC = new Mode("ENCRYPT_CBC", 0);
        public static final Mode HASH = new Mode("HASH", 1);
        private static final /* synthetic */ Mode[] $VALUES;
        static /* synthetic */ Class class$com$levigo$util$tools$ConfigurationValueCrypter$Mode;

        public static Mode[] values() {
            return (Mode[])$VALUES.clone();
        }

        public static Mode valueOf(String name) {
            Class<?> clazz = class$com$levigo$util$tools$ConfigurationValueCrypter$Mode;
            if (clazz == null) {
                clazz = class$com$levigo$util$tools$ConfigurationValueCrypter$Mode = new Mode[0].getClass().getComponentType();
            }
            return (Mode)Enum_.valueOf((Class)clazz, (String)name);
        }

        private Mode() {
            super((String)var1_1, n);
        }

        static {
            $VALUES = new Mode[]{ENCRYPT_CBC, HASH};
            Class<?> clazz = class$com$levigo$util$tools$ConfigurationValueCrypter$Mode;
            if (clazz == null) {
                clazz = class$com$levigo$util$tools$ConfigurationValueCrypter$Mode = new Mode[0].getClass().getComponentType();
            }
            Enum_.setEnumConstants((Class)clazz, (Enum_[])Mode.values());
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Algorithm
    extends Enum_<Algorithm> {
        public static final Algorithm MD5 = new Algorithm("MD5", 0);
        public static final Algorithm SHA1 = new Algorithm("SHA1", 1);
        private static final /* synthetic */ Algorithm[] $VALUES;
        static /* synthetic */ Class class$com$levigo$util$tools$ConfigurationValueCrypter$Algorithm;

        public static Algorithm[] values() {
            return (Algorithm[])$VALUES.clone();
        }

        public static Algorithm valueOf(String name) {
            Class<?> clazz = class$com$levigo$util$tools$ConfigurationValueCrypter$Algorithm;
            if (clazz == null) {
                clazz = class$com$levigo$util$tools$ConfigurationValueCrypter$Algorithm = new Algorithm[0].getClass().getComponentType();
            }
            return (Algorithm)Enum_.valueOf((Class)clazz, (String)name);
        }

        private Algorithm() {
            super((String)var1_1, n);
        }

        static {
            $VALUES = new Algorithm[]{MD5, SHA1};
            Class<?> clazz = class$com$levigo$util$tools$ConfigurationValueCrypter$Algorithm;
            if (clazz == null) {
                clazz = class$com$levigo$util$tools$ConfigurationValueCrypter$Algorithm = new Algorithm[0].getClass().getComponentType();
            }
            Enum_.setEnumConstants((Class)clazz, (Enum_[])Algorithm.values());
        }
    }
}

